/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.factory;

import com.cleanroommc.modularui.api.IGuiHolder;
import com.cleanroommc.modularui.factory.AbstractUIFactory;
import com.cleanroommc.modularui.factory.GuiManager;
import com.cleanroommc.modularui.factory.SidedPosGuiData;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class SidedTileEntityGuiFactory
extends AbstractUIFactory<SidedPosGuiData> {
    public static final SidedTileEntityGuiFactory INSTANCE = new SidedTileEntityGuiFactory();

    public static <T extends TileEntity> void open(EntityPlayer player, T tile, EnumFacing facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(tile);
        Objects.requireNonNull(facing);
        if (tile.func_145837_r()) {
            throw new IllegalArgumentException("Can't open invalid TileEntity GUI!");
        }
        if (player.field_70170_p != tile.func_145831_w()) {
            throw new IllegalArgumentException("TileEntity must be in same dimension as the player!");
        }
        BlockPos pos = tile.func_174877_v();
        SidedPosGuiData data = new SidedPosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing);
        GuiManager.open(INSTANCE, data, (EntityPlayerMP)player);
    }

    public static void open(EntityPlayer player, BlockPos pos, EnumFacing facing) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(pos);
        Objects.requireNonNull(facing);
        SidedPosGuiData data = new SidedPosGuiData(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing);
        GuiManager.open(INSTANCE, data, (EntityPlayerMP)player);
    }

    private SidedTileEntityGuiFactory() {
        super("mui:sided_tile");
    }

    @Override
    @NotNull
    public IGuiHolder<SidedPosGuiData> getGuiHolder(SidedPosGuiData data) {
        return Objects.requireNonNull(this.castGuiHolder(data.getTileEntity()), "Found TileEntity is not a gui holder!");
    }

    @Override
    public void writeGuiData(SidedPosGuiData guiData, PacketBuffer buffer) {
        buffer.func_150787_b(guiData.getX());
        buffer.func_150787_b(guiData.getY());
        buffer.func_150787_b(guiData.getZ());
        buffer.writeByte(guiData.getSide().func_176745_a());
    }

    @Override
    @NotNull
    public SidedPosGuiData readGuiData(EntityPlayer player, PacketBuffer buffer) {
        return new SidedPosGuiData(player, buffer.func_150792_a(), buffer.func_150792_a(), buffer.func_150792_a(), EnumFacing.field_82609_l[buffer.readByte()]);
    }
}

