/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network.packets;

import com.cleanroommc.modularui.network.IPacket;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularContainer;
import com.cleanroommc.modularui.screen.ModularScreen;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Nullable;

public class PacketSyncHandler
implements IPacket {
    private String key;
    private PacketBuffer packet;

    public PacketSyncHandler() {
    }

    public PacketSyncHandler(String key, PacketBuffer packet) {
        this.key = key;
        this.packet = packet;
    }

    @Override
    public void write(PacketBuffer buf) {
        NetworkUtils.writeStringSafe(buf, this.key, 64, true);
        NetworkUtils.writeByteBuf(buf, (ByteBuf)this.packet);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.key = NetworkUtils.readStringSafe(buf);
        this.packet = NetworkUtils.readPacketBuffer(buf);
    }

    @Override
    @Nullable
    public IPacket executeClient(NetHandlerPlayClient handler) {
        ModularScreen screen = ModularScreen.getCurrent();
        if (screen != null) {
            try {
                screen.getSyncManager().receiveWidgetUpdate(this.key, this.packet.func_150792_a(), this.packet);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IPacket executeServer(NetHandlerPlayServer handler) {
        Container container = handler.field_147369_b.field_71070_bA;
        if (container instanceof ModularContainer) {
            ModularContainer modularContainer = (ModularContainer)container;
            try {
                modularContainer.getSyncManager().receiveWidgetUpdate(this.key, this.packet.func_150792_a(), this.packet);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

