/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.value.sync.IStringSyncValue;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class StringSyncValue
extends ValueSyncHandler<String>
implements IStringSyncValue<String> {
    private final Supplier<String> getter;
    private final Consumer<String> setter;
    private String cache;

    public StringSyncValue(Supplier<String> getter, Consumer<String> setter) {
        this.getter = getter;
        this.setter = setter;
        this.cache = getter.get();
    }

    @Contract(value="null, _, null, _ -> fail")
    public StringSyncValue(@Nullable Supplier<String> clientGetter, @Nullable Consumer<String> clientSetter, @Nullable Supplier<String> serverGetter, @Nullable Consumer<String> serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (NetworkUtils.isClient()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.get();
    }

    @Override
    public String getValue() {
        return this.cache;
    }

    @Override
    public String getStringValue() {
        return this.cache;
    }

    @Override
    public void setValue(String value, boolean setSource, boolean sync) {
        this.setStringValue(value, setSource, sync);
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        if (sync) {
            this.sync(0, this::write);
        }
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || !Objects.equals(this.getter.get(), this.cache)) {
            this.setValue(this.getter.get(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void write(PacketBuffer buffer) {
        NetworkUtils.writeStringSafe(buffer, this.getValue(), 32693);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue(NetworkUtils.readStringSafe(buffer), true, false);
    }
}

