/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.crash.CrashReport;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.inventory.SlotFurnaceOutput;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.MouseTweaks;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;
import yalter.mousetweaks.api.MouseTweaksIgnore;
import yalter.mousetweaks.impl.IGuiScreenHandler;
import yalter.mousetweaks.impl.MouseButton;
import yalter.mousetweaks.reflect.Reflection;
import yalter.mousetweaks.util.Constants;

public class GuiContainerHandler
implements IGuiScreenHandler {
    protected Minecraft mc = Minecraft.func_71410_x();
    protected GuiContainer guiContainer;
    protected Method handleMouseClick;

    public GuiContainerHandler(GuiContainer guiContainer) {
        this.guiContainer = guiContainer;
        this.handleMouseClick = Reflection.getHMCMethod(guiContainer);
    }

    private int getDisplayWidth() {
        return this.mc.field_71443_c;
    }

    private int getDisplayHeight() {
        return this.mc.field_71440_d;
    }

    private int getRequiredMouseX() {
        return Mouse.getX() * this.guiContainer.field_146294_l / this.getDisplayWidth();
    }

    private int getRequiredMouseY() {
        return this.guiContainer.field_146295_m - Mouse.getY() * this.guiContainer.field_146295_m / this.getDisplayHeight() - 1;
    }

    @Override
    public boolean isMouseTweaksDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksIgnore.class) || Reflection.guiContainerClass == null || MouseTweaks.instance.isMouseTweakDisabled(this.guiContainer.getClass());
    }

    @Override
    public boolean isWheelTweakDisabled() {
        return this.guiContainer.getClass().isAnnotationPresent(MouseTweaksDisableWheelTweak.class) || MouseTweaks.instance.isWheelTweakDisabled(this.guiContainer.getClass());
    }

    @Override
    public List<Slot> getSlots() {
        return this.guiContainer.field_147002_h.field_75151_b;
    }

    @Override
    public Slot getSlotUnderMouse() {
        try {
            return (Slot)Reflection.guiContainerClass.invokeMethod(this.guiContainer, Constants.GETSLOTATPOSITION_NAME.forgeName, this.getRequiredMouseX(), this.getRequiredMouseY());
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"GuiContainer.getSlotAtPosition() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean disableRMBDraggingFunctionality() {
        Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.IGNOREMOUSEUP_NAME.forgeName, true);
        if (((Boolean)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName)).booleanValue() && (Integer)Reflection.guiContainerClass.getFieldValue(this.guiContainer, Constants.DRAGSPLITTINGBUTTON_NAME.forgeName) == 1) {
            Reflection.guiContainerClass.setFieldValue(this.guiContainer, Constants.DRAGSPLITTING_NAME.forgeName, false);
            return true;
        }
        return false;
    }

    @Override
    public void clickSlot(Slot slot, MouseButton mouseButton, boolean shiftPressed) {
        try {
            this.handleMouseClick.invoke((Object)this.guiContainer, slot, slot.field_75222_d, mouseButton.getValue(), shiftPressed ? ClickType.QUICK_MOVE : ClickType.PICKUP);
        }
        catch (InvocationTargetException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"handleMouseClick() threw an exception when called from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
        catch (IllegalAccessException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Calling handleMouseClick() from MouseTweaks.");
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public boolean isCraftingOutput(Slot slot) {
        return slot instanceof SlotCrafting || slot instanceof SlotFurnaceOutput || slot instanceof SlotMerchantResult || this.guiContainer.field_147002_h instanceof ContainerRepair && slot.field_75222_d == 2;
    }

    @Override
    public boolean isIgnored(Slot slot) {
        return false;
    }

    @Override
    public int isSlotPrioritized(Slot slot, ItemStack stack) {
        if (stack.func_77973_b().getItemBurnTime(stack) != 0) {
            if (slot instanceof SlotFurnaceFuel) {
                return 1;
            }
            return 0;
        }
        return -1;
    }
}

