/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public class LuaList<T> {
    private static final Collector<Object, ?, LuaList<Object>> COLLECTOR = Collector.of(LuaList::new, LuaList::add, (a, b) -> {
        for (Object t : b.map.values()) {
            a.add(t);
        }
        return a;
    }, Collector.Characteristics.IDENTITY_FINISH);
    private final Map<Integer, T> map;
    private int lastIndex = 0;

    public static <T> Collector<T, ?, LuaList<T>> toLuaList() {
        return COLLECTOR;
    }

    public static <T, R> LuaList<R> of(Collection<T> items, Function<T, R> map) {
        LuaList<R> list = new LuaList<R>(items.size());
        for (T item : items) {
            list.add(map.apply(item));
        }
        return list;
    }

    public LuaList() {
        this.map = new HashMap<Integer, T>();
    }

    public LuaList(int expectedSize) {
        this.map = new HashMap<Integer, T>(expectedSize);
    }

    public LuaList(Collection<T> of) {
        this(of.size());
        this.addAll(of);
    }

    public LuaList(T[] array) {
        this(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.map.put(i + 1, array[i]);
        }
        this.lastIndex = array.length;
    }

    public void add(T e) {
        int i = ++this.lastIndex;
        if (e != null) {
            this.map.put(i, e);
        }
    }

    public void addAll(Iterable<T> from) {
        from.forEach(this::add);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<Integer, T> asMap() {
        return this.map;
    }
}

