/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method.wrapper;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.method.wrapper.ArgumentType;

@Injects
public final class ArgumentTypes {
    public static final ArgumentType<String> STRING = new ArgumentType<String>(){

        @Override
        public String name() {
            return "string";
        }

        @Override
        @Nonnull
        public String get(@Nonnull Object[] args, int index) throws LuaException {
            return ArgumentHelper.getString((Object[])args, (int)index);
        }

        @Override
        @Nullable
        public String opt(@Nonnull Object[] args, int index) throws LuaException {
            return ArgumentHelper.optString((Object[])args, (int)index, null);
        }
    };
    public static final ArgumentType<ResourceLocation> RESOURCE = STRING.map(ResourceLocation::new);
    public static final ArgumentType<Item> ITEM = RESOURCE.map(name -> {
        Item item = (Item)Item.field_150901_e.func_82594_a(name);
        if (item == null || !Item.field_150901_e.func_148741_d(name)) {
            throw new LuaException("Unknown item '" + name + "'");
        }
        return item;
    });
    public static final ArgumentType<Fluid> FLUID = STRING.map(name -> {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        if (fluid == null) {
            throw new LuaException("Unknown fluid '" + name + "'");
        }
        return fluid;
    });
    public static final ArgumentType<UUID> UUID_ARG = new ArgumentType<UUID>(){

        @Override
        public String name() {
            return "string";
        }

        @Override
        @Nonnull
        public UUID get(@Nonnull Object[] args, int index) throws LuaException {
            if (index >= args.length) {
                throw ArgumentHelper.badArgument((int)index, (String)"string", (String)"no value");
            }
            Object value = args[index];
            if (value instanceof String) {
                String uuid = ((String)value).toLowerCase(Locale.ENGLISH);
                try {
                    return UUID.fromString(uuid);
                }
                catch (IllegalArgumentException e) {
                    throw new LuaException("Bad uuid '" + uuid + "' for argument #" + (index + 1));
                }
            }
            throw ArgumentHelper.badArgument((int)index, (String)"string", (Object)value);
        }
    };
    public static final ArgumentType<Map<?, ?>> TABLE = new ArgumentType<Map<?, ?>>(){

        @Override
        public String name() {
            return "table";
        }

        @Override
        @Nonnull
        public Map<?, ?> get(@Nonnull Object[] args, int index) throws LuaException {
            return ArgumentHelper.getTable((Object[])args, (int)index);
        }

        @Override
        @Nullable
        public Map<?, ?> opt(@Nonnull Object[] args, int index) throws LuaException {
            return ArgumentHelper.optTable((Object[])args, (int)index, null);
        }
    };

    private ArgumentTypes() {
    }
}

