/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.keyboard;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.squiddev.plethora.gameplay.keyboard.ServerKeyListener;
import org.squiddev.plethora.gameplay.registry.BasicMessage;

public class KeyMessage
implements BasicMessage {
    private List<KeyPress> presses;
    private List<Integer> ups;

    public KeyMessage() {
    }

    public KeyMessage(List<KeyPress> presses, List<Integer> ups) {
        this.presses = Lists.newArrayList(presses);
        this.ups = Lists.newArrayList(ups);
    }

    public void fromBytes(ByteBuf buf) {
        int pressSize = buf.readInt();
        this.presses = Lists.newArrayListWithCapacity((int)pressSize);
        for (int i = 0; i < pressSize; ++i) {
            int key = buf.readInt();
            boolean repeat = buf.readBoolean();
            char ch = buf.readChar();
            this.presses.add(new KeyPress(key, repeat, ch));
        }
        int upSize = buf.readInt();
        this.ups = Lists.newArrayListWithCapacity((int)upSize);
        for (int i = 0; i < upSize; ++i) {
            this.ups.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.presses.size());
        for (KeyPress press : this.presses) {
            buf.writeInt(press.key);
            buf.writeBoolean(press.repeat);
            buf.writeChar((int)press.ch);
        }
        buf.writeInt(this.ups.size());
        for (Integer up : this.ups) {
            buf.writeInt(up.intValue());
        }
    }

    @Override
    public void onMessage(MessageContext ctx) {
        ServerKeyListener.process(ctx.getServerHandler().field_147369_b, this.presses, this.ups);
    }

    public static class KeyPress {
        public final int key;
        public final boolean repeat;
        public final char ch;

        public KeyPress(int key, boolean repeat, char ch) {
            this.key = key;
            this.repeat = repeat;
            this.ch = ch;
        }
    }
}

