/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.squiddev.plethora.gameplay.ItemBase;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.neural.NeuralComputer;
import org.squiddev.plethora.utils.TinySlot;

public final class ItemComputerHandler {
    public static final int WIDTH = 39;
    public static final int HEIGHT = 13;
    public static final String SESSION_ID = "session_id";
    public static final String INSTANCE_ID = "instance_id";
    public static final String COMPUTER_ID = "id";
    public static final String ITEMS = "items";
    public static final String DIRTY = "dirty";
    public static final String MODULE_DATA = "module_data";

    private ItemComputerHandler() {
    }

    public static NeuralComputer getServer(@Nonnull ItemStack stack, EntityLivingBase owner, TinySlot inventory) {
        NBTTagCompound tag = ItemBase.getTag(stack);
        ServerComputerRegistry manager = ComputerCraft.serverComputerRegistry;
        int sessionId = manager.getSessionID();
        NeuralComputer neural = null;
        if (tag.func_74762_e(SESSION_ID) == sessionId && tag.func_74764_b(INSTANCE_ID) && manager.contains(tag.func_74762_e(INSTANCE_ID))) {
            ServerComputer computer = (ServerComputer)manager.get(tag.func_74762_e(INSTANCE_ID));
            if (computer instanceof NeuralComputer) {
                neural = (NeuralComputer)computer;
            } else {
                Plethora.LOG.error("Computer is not NeuralComputer but " + computer);
            }
        }
        if (neural == null) {
            int instanceId = manager.getUnusedInstanceID();
            int computerId = tag.func_74764_b(COMPUTER_ID) ? tag.func_74762_e(COMPUTER_ID) : ComputerCraftAPI.createUniqueNumberedSaveDir((World)owner.func_130014_f_(), (String)"computer");
            String label = stack.func_82837_s() ? stack.func_82833_r() : null;
            neural = new NeuralComputer(owner.func_130014_f_(), computerId, label, instanceId);
            neural.readModuleData(tag.func_74775_l(MODULE_DATA));
            manager.add(instanceId, (ServerComputer)neural);
            tag.func_74768_a(SESSION_ID, sessionId);
            tag.func_74768_a(INSTANCE_ID, instanceId);
            tag.func_74768_a(COMPUTER_ID, computerId);
            neural.turnOn();
            if (inventory != null) {
                inventory.markDirty();
            }
        }
        return neural;
    }

    public static NeuralComputer tryGetServer(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemBase.getTag(stack);
        ServerComputerRegistry manager = ComputerCraft.serverComputerRegistry;
        int sessionId = manager.getSessionID();
        if (tag.func_74762_e(SESSION_ID) == sessionId && tag.func_74764_b(INSTANCE_ID) && manager.contains(tag.func_74762_e(INSTANCE_ID))) {
            ServerComputer computer = (ServerComputer)manager.get(tag.func_74762_e(INSTANCE_ID));
            if (computer instanceof NeuralComputer) {
                return (NeuralComputer)computer;
            }
            Plethora.LOG.error("Computer is not NeuralComputer but " + computer);
            return null;
        }
        return null;
    }

    public static ClientComputer getClient(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemBase.getTag(stack);
        int instanceId = tag.func_74762_e(INSTANCE_ID);
        if (instanceId < 0) {
            return null;
        }
        if (!ComputerCraft.clientComputerRegistry.contains(instanceId)) {
            ComputerCraft.clientComputerRegistry.add(instanceId, new ClientComputer(instanceId));
        }
        return (ClientComputer)ComputerCraft.clientComputerRegistry.get(instanceId);
    }
}

