/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.api.IPlayerOwnable;

public final class PlayerHelpers {
    private static final Predicate<Entity> collidablePredicate = Predicates.and((Predicate)EntitySelectors.field_180132_d, Entity::func_70067_L);

    private PlayerHelpers() {
    }

    @Nonnull
    public static RayTraceResult findHitGuess(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K && player instanceof EntityPlayerSP) {
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            return result == null ? new RayTraceResult(RayTraceResult.Type.MISS, player.func_174791_d(), null, null) : result;
        }
        return PlayerHelpers.findHit((EntityLivingBase)player, player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
    }

    @Nonnull
    public static RayTraceResult findHit(EntityPlayerMP player, EntityLivingBase entity) {
        return PlayerHelpers.findHit(entity, player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
    }

    @Nonnull
    public static RayTraceResult findHit(EntityLivingBase entity, double range) {
        Vec3d origin = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d look = entity.func_70040_Z();
        Vec3d target = new Vec3d(origin.field_72450_a + look.field_72450_a * range, origin.field_72448_b + look.field_72448_b * range, origin.field_72449_c + look.field_72449_c * range);
        RayTraceResult hit = entity.func_130014_f_().func_72933_a(origin, target);
        List entityList = entity.func_130014_f_().func_175674_a((Entity)entity, entity.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0), arg_0 -> collidablePredicate.test(arg_0));
        Entity closestEntity = null;
        Vec3d closestVec = null;
        double closestDistance = range;
        for (Entity entityHit : entityList) {
            double distance;
            float size = entityHit.func_70111_Y();
            AxisAlignedBB box = entityHit.func_174813_aQ().func_72314_b((double)size, (double)size, (double)size);
            RayTraceResult intercept = box.func_72327_a(origin, target);
            if (box.func_72318_a(origin)) {
                if (!(closestDistance >= 0.0)) continue;
                closestEntity = entityHit;
                closestVec = intercept == null ? origin : intercept.field_72307_f;
                closestDistance = 0.0;
                continue;
            }
            if (intercept == null || !((distance = origin.func_72438_d(intercept.field_72307_f)) < closestDistance) && closestDistance != 0.0) continue;
            if (entityHit == entityHit.func_184187_bx() && !entityHit.canRiderInteract()) {
                if (closestDistance != 0.0) continue;
                closestEntity = entityHit;
                closestVec = intercept.field_72307_f;
                continue;
            }
            closestEntity = entityHit;
            closestVec = intercept.field_72307_f;
            closestDistance = distance;
        }
        if (closestEntity instanceof EntityLivingBase && closestDistance <= range && (hit == null || entity.func_174818_b(hit.func_178782_a()) > closestDistance * closestDistance)) {
            return new RayTraceResult(closestEntity, closestVec);
        }
        if (hit == null) {
            return new RayTraceResult(RayTraceResult.Type.MISS, origin, null, null);
        }
        return hit;
    }

    @Nullable
    public static GameProfile getProfile(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_146103_bH();
        }
        if (entity instanceof IPlayerOwnable) {
            return ((IPlayerOwnable)entity).getOwningProfile();
        }
        return null;
    }

    @Nullable
    public static GameProfile readProfile(@Nonnull NBTTagCompound tag) {
        if (!tag.func_150297_b("owner", 10)) {
            return null;
        }
        NBTTagCompound owner = tag.func_74775_l("owner");
        return new GameProfile(new UUID(owner.func_74763_f("upper_id"), owner.func_74763_f("lower_id")), owner.func_74779_i("name"));
    }

    public static void writeProfile(@Nonnull NBTTagCompound tag, @Nullable GameProfile profile) {
        if (profile == null) {
            tag.func_82580_o("owner");
        } else {
            NBTTagCompound owner = new NBTTagCompound();
            tag.func_74782_a("owner", (NBTBase)owner);
            owner.func_74772_a("upper_id", profile.getId().getMostSignificantBits());
            owner.func_74772_a("lower_id", profile.getId().getLeastSignificantBits());
            owner.func_74778_a("name", profile.getName());
        }
    }
}

