/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.api;

import c4.conarm.lib.capabilities.ArmorAbilityHandler;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.net.PacketHandleToggleGui;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketRequestToggleGui;
import landmaster.plustic.net.PacketUpdateToggleGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Toggle {
    public static final ResourceLocation TOGGLEARMOR_CAPLOCATION = new ResourceLocation("plustic", "togglearmor_cap");
    private static final Set<String> toggleable = new HashSet<String>();
    private static final Map<String, String> toggleableAlias = new HashMap<String, String>();
    @CapabilityInject(value=IToggleArmor.class)
    private static Capability<IToggleArmor> TOGGLE_ARMOR = null;
    public static final String ARMOR_FLAG = "\\";

    @SubscribeEvent
    public static void addToggleArmorCapability(AttachCapabilitiesEvent<Entity> event) {
        if (Loader.isModLoaded((String)"conarm") && event.getObject() instanceof EntityPlayer) {
            event.addCapability(TOGGLEARMOR_CAPLOCATION, (ICapabilityProvider)new ToggleArmorProvider());
        }
    }

    public static void addToggleable(String trait) {
        toggleable.add(trait);
    }

    public static void addToggleableAlias(String trait, String alias) {
        toggleableAlias.put(alias, trait);
    }

    public static String unwrapAlias(String alias) {
        String res = alias;
        while (toggleableAlias.containsKey(res)) {
            res = toggleableAlias.get(alias);
        }
        return res;
    }

    public static String rawIdentifier(String identifier) {
        if (identifier.startsWith(ARMOR_FLAG)) {
            return identifier.substring(ARMOR_FLAG.length());
        }
        return identifier;
    }

    @SubscribeEvent
    public static void copyOnDeath(PlayerEvent.Clone event) {
        IToggleArmor oldCap = (IToggleArmor)event.getOriginal().getCapability(TOGGLE_ARMOR, null);
        IToggleArmor newCap = (IToggleArmor)event.getEntityPlayer().getCapability(TOGGLE_ARMOR, null);
        if (oldCap != null && newCap != null) {
            newCap.getDisabled().clear();
            newCap.getDisabled().addAll(oldCap.getDisabled());
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Toggle.syncArmorToClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Toggle.syncArmorToClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void changeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        Toggle.syncArmorToClient((PlayerEvent)event);
    }

    protected static void syncArmorToClient(PlayerEvent event) {
        IToggleArmor cap = (IToggleArmor)event.player.getCapability(TOGGLE_ARMOR, null);
        if (cap != null && !event.player.field_70170_p.field_72995_K) {
            for (String disabled : cap.getDisabled()) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketUpdateToggleGui(ARMOR_FLAG + disabled, false), (EntityPlayerMP)event.player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void testAndToggle(InputEvent.KeyInputEvent event) {
        if (PlusTiC.proxy.isControlPressed("toggle_gui")) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestToggleGui());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        if (event.getItemStack() == null || !(event.getItemStack().func_77973_b() instanceof ToolCore)) {
            return;
        }
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            String identifier = traits.func_150307_f(i);
            if (!toggleable.contains(identifier)) continue;
            boolean enabled = !toggle.func_74764_b(identifier);
            event.getToolTip().add(I18n.func_135052_a((String)("tooltip.plustic.toggle.state." + enabled), (Object[])new Object[]{TinkerRegistry.getModifier((String)identifier).getLocalizedName()}));
        }
    }

    public static Stream<String> getToggleableArmor(EntityPlayer player) {
        return Loader.isModLoaded((String)"conarm") ? Optional.ofNullable(ArmorAbilityHandler.getArmorAbilitiesData((EntityPlayer)player)).map(ArmorAbilityHandler.IArmorAbilities::getAbilityMap).map(Map::keySet).map(set -> set.stream().filter(str -> toggleable.contains(ARMOR_FLAG + str))).orElse(Stream.empty()) : Stream.empty();
    }

    public static boolean canToggle(ItemStack is) {
        return Toggle.canToggle(TagUtil.getTagSafe((ItemStack)is));
    }

    public static boolean canToggle(NBTTagCompound nbt) {
        NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            if (!toggleable.contains(traits.func_150307_f(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean getToggleState(ItemStack is, String identifier) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)is);
        return Toggle.getToggleState(nbt, identifier);
    }

    public static boolean getToggleState(NBTTagCompound nbt, String identifier) {
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        return !toggleable.contains(identifier) || !toggle.func_74764_b(identifier);
    }

    public static void setToggleState(NBTTagCompound nbt, String identifier, boolean value) {
        if (!toggleable.contains(identifier)) {
            return;
        }
        NBTTagCompound toggle = TagUtil.getTagSafe((NBTTagCompound)nbt, (String)"PlusTiC_toggle");
        if (value) {
            toggle.func_82580_o(identifier);
        } else {
            toggle.func_74757_a(identifier, false);
        }
        nbt.func_74782_a("PlusTiC_toggle", (NBTBase)toggle);
    }

    static {
        MinecraftForge.EVENT_BUS.register(Toggle.class);
        CapabilityManager.INSTANCE.register(IToggleArmor.class, (Capability.IStorage)new Capability.IStorage<IToggleArmor>(){

            public NBTBase writeNBT(Capability<IToggleArmor> capability, IToggleArmor instance, EnumFacing side) {
                NBTTagList nbt = new NBTTagList();
                for (String disabled : instance.getDisabled()) {
                    nbt.func_74742_a((NBTBase)new NBTTagString(disabled));
                }
                return nbt;
            }

            public void readNBT(Capability<IToggleArmor> capability, IToggleArmor instance, EnumFacing side, NBTBase nbt) {
                for (NBTBase elem : (NBTTagList)nbt) {
                    instance.getDisabled().add(((NBTTagString)elem).func_150285_a_());
                }
            }
        }, () -> new ToggleArmor());
    }

    public static class Gui
    extends GuiScreen {
        @CapabilityInject(value=IToggleArmor.class)
        private static Capability<IToggleArmor> TOGGLE_ARMOR = null;
        public static final int OPTIONS_PER_PAGE = 6;
        private final ResourceLocation background = new ResourceLocation("plustic", "textures/gui/toggle.png");
        private int page;
        private EntityPlayer player;
        private List<String> identifiers;
        private BooleanList enableds;
        private int xSize = 176;
        private int ySize = 128;
        private int guiLeft;
        private int guiTop;

        public Gui(EntityPlayer player, Collection<String> armorAbilities) {
            this.player = player;
            this.page = 0;
            Object2BooleanLinkedOpenHashMap temp = new Object2BooleanLinkedOpenHashMap();
            NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)this.player.func_184614_ca());
            NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)nbt);
            for (int i = 0; i < traits.func_74745_c(); ++i) {
                String identifier = Toggle.unwrapAlias(traits.func_150307_f(i));
                if (!toggleable.contains(identifier)) continue;
                temp.put((Object)identifier, Toggle.getToggleState(nbt, identifier));
            }
            this.identifiers = new ArrayList<String>((Collection<String>)temp.keySet());
            this.enableds = new BooleanArrayList(temp.values());
            if (player.hasCapability(TOGGLE_ARMOR, null)) {
                IToggleArmor cap = (IToggleArmor)player.getCapability(TOGGLE_ARMOR, null);
                Set<String> disabled = cap.getDisabled();
                for (String ability : armorAbilities) {
                    this.identifiers.add(Toggle.ARMOR_FLAG + ability);
                    this.enableds.add(!disabled.contains(ability));
                }
            }
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.guiLeft = (this.field_146294_l - this.xSize) / 2;
            this.guiTop = (this.field_146295_m - this.ySize) / 2;
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            int i;
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GL11.glEnable((int)3042);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.header.toggle", (Object[])new Object[0]), this.guiLeft + 5, this.guiTop + 5, 0xFFFFFF);
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            for (i = 0; i < Math.min(6, this.identifiers.size() - this.page * 6); ++i) {
                this.func_73729_b(this.guiLeft + 7, this.guiTop + 18 * (i + 1), 0, 128, 152, 16);
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.background);
            if (this.page > 0) {
                this.func_73729_b(this.guiLeft + 160, this.guiTop + 18, 176, 12, 12, 21);
            }
            if (this.page < this.identifiers.size() / 6 - (this.identifiers.size() % 6 == 0 ? 1 : 0)) {
                this.func_73729_b(this.guiLeft + 160, this.guiTop + 100, 188, 12, 12, 21);
            }
            for (i = this.page * 6; i < Math.min((this.page + 1) * 6, this.identifiers.size()); ++i) {
                String identifier = this.identifiers.get(i);
                String rawIdentifier = Toggle.rawIdentifier(identifier);
                boolean isArmor = identifier.startsWith(Toggle.ARMOR_FLAG);
                boolean enabled = (Boolean)this.enableds.get(i);
                String locName = I18n.func_135052_a((String)(isArmor ? "gui.toggle.armor" : "gui.toggle.tool"), (Object[])new Object[]{I18n.func_135052_a((String)("modifier." + rawIdentifier + ".name"), (Object[])new Object[0])});
                this.field_146289_q.func_78276_b(locName, this.guiLeft + 10, this.guiTop + 18 * (i % 6 + 1) + 3, 0xFFFFFF);
                this.field_146297_k.field_71446_o.func_110577_a(this.background);
                this.func_73729_b(this.guiLeft + 130, this.guiTop + 18 * (i % 6 + 1) + 1, 176 + (enabled ? 0 : 12), 0, 12, 12);
                if (!this.isPointInRegion(7, 18 * (i % 6 + 1), 158, 16, mouseX, mouseY)) continue;
                this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"tooltip.plustic.toggle.info", (Object[])new Object[0]), I18n.func_135052_a((String)("tooltip.plustic.toggle.state." + enabled), (Object[])new Object[]{locName})), mouseX, mouseY);
            }
        }

        public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            for (int i = 0; i < Math.min(6, this.identifiers.size() - this.page * 6); ++i) {
                if (!this.isPointInRegion(7, 18 * (i + 1), 152, 16, mouseX, mouseY)) continue;
                String identifier = this.identifiers.get(this.page * 6 + i);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketHandleToggleGui(identifier));
                return;
            }
            if (this.isPointInRegion(160, 18, 12, 21, mouseX, mouseY)) {
                this.page = Math.max(this.page - 1, 0);
            } else if (this.isPointInRegion(160, 100, 12, 21, mouseX, mouseY)) {
                this.page = Math.min(this.page + 1, this.identifiers.size() / 6 - (this.identifiers.size() % 6 == 0 ? 1 : 0));
            }
        }

        protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
            int i = this.guiLeft;
            int j = this.guiTop;
            return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
        }

        public void update(String identifier, boolean value) {
            int ind = this.identifiers.indexOf(identifier);
            if (ind >= 0) {
                this.enableds.set(ind, value);
            }
        }
    }

    private static class ToggleArmorProvider
    implements ICapabilitySerializable<NBTTagList> {
        @CapabilityInject(value=IToggleArmor.class)
        private static Capability<IToggleArmor> TOGGLE_ARMOR = null;
        private final ToggleArmor cap = new ToggleArmor();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == TOGGLE_ARMOR;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == TOGGLE_ARMOR) {
                return (T)this.cap;
            }
            return null;
        }

        public NBTTagList serializeNBT() {
            return (NBTTagList)TOGGLE_ARMOR.writeNBT((Object)this.cap, null);
        }

        public void deserializeNBT(NBTTagList nbt) {
            TOGGLE_ARMOR.readNBT((Object)this.cap, null, (NBTBase)nbt);
        }
    }

    private static class ToggleArmor
    implements IToggleArmor {
        private Set<String> disableds = new ObjectOpenHashSet();

        private ToggleArmor() {
        }

        @Override
        public Set<String> getDisabled() {
            return this.disableds;
        }
    }

    public static interface IToggleArmor {
        public Set<String> getDisabled();
    }
}

