/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.apiimpl.DimletConfigurationManager;
import mcjty.rftoolsdim.config.Filter;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimletRules {
    private static List<Pair<Filter, Settings>> rules;

    private static List<List<Pair<Filter, Settings>>> getCompleteRules() {
        ArrayList<List<Pair<Filter, Settings>>> completeRules = new ArrayList<List<Pair<Filter, Settings>>>();
        for (Map.Entry<String, DimletConfigurationManager> entry : DimletConfigurationManager.getConfigurationManagers().entrySet()) {
            completeRules.add(entry.getValue().getRules());
        }
        completeRules.add(rules);
        return completeRules;
    }

    public static Settings getSettings(DimletType type, String mod, String name, Set<Filter.Feature> features, int meta, Map<String, String> properties) {
        Settings.Builder builder = new Settings.Builder();
        block0: for (List<Pair<Filter, Settings>> ruleList : DimletRules.getCompleteRules()) {
            for (Pair<Filter, Settings> pair : ruleList) {
                Filter filter = (Filter)pair.getLeft();
                if (!filter.match(type, mod, name, meta, properties, features)) continue;
                Settings settings = (Settings)pair.getRight();
                builder.merge(settings);
                if (!settings.isComplete()) continue;
                continue block0;
            }
        }
        return builder.complete().build();
    }

    public static Settings getSettings(DimletKey key, String mod, Set<Filter.Feature> features, Map<String, String> properties) {
        String id = key.getId();
        int meta = 0;
        if (DimletType.DIMLET_MATERIAL.equals((Object)key.getType())) {
            int firstIndexOf = StringUtils.indexOf((CharSequence)id, (CharSequence)":");
            id = id.substring(firstIndexOf + 1);
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)id, (CharSequence)"@");
            meta = Integer.parseInt(id.substring(lastIndexOf + 1));
            id = id.substring(0, lastIndexOf);
        } else if (DimletType.DIMLET_LIQUID.equals((Object)key.getType())) {
            int firstIndexOf = StringUtils.indexOf((CharSequence)id, (CharSequence)":");
            id = id.substring(firstIndexOf + 1);
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)id, (CharSequence)"@");
            meta = Integer.parseInt(id.substring(lastIndexOf + 1));
            id = id.substring(0, lastIndexOf);
        }
        return DimletRules.getSettings(key.getType(), mod, id, features, meta, properties);
    }

    public static Settings getSettings(DimletKey key, String mod) {
        return DimletRules.getSettings(key, mod, Collections.emptySet(), Collections.emptyMap());
    }

    public static List<Pair<Filter, Settings>> getRules() {
        return rules;
    }

    public static void syncRulesFromServer(List<Pair<Filter, Settings>> rules) {
        DimletRules.rules = rules;
        KnownDimletConfiguration.init();
        DimletRandomizer.init();
    }

    public static void readRules(File directory) {
        List<Pair<Filter, Settings>> builtinRules;
        File file = new File(directory.getPath() + File.separator + "rftools", "dimlets.json");
        List<Object> userRules = Collections.emptyList();
        if (file.exists()) {
            Logging.log((String)"Reading dimlets.json from config");
            userRules = DimletRules.readRulesFromFile(file);
        }
        Logging.log((String)"Reading default dimlets.json");
        try (InputStream inputstream = RFToolsDim.class.getResourceAsStream("/assets/rftoolsdim/text/dimlets.json");){
            builtinRules = DimletRules.readRulesFromFile(inputstream, "Builtin dimlets.json");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (file.exists()) {
            file.delete();
        }
        boolean addBuiltin = false;
        try (PrintWriter writer = new PrintWriter(file);){
            if (userRules.isEmpty()) {
                addBuiltin = true;
            } else if (userRules.get(userRules.size() - 1) == null) {
                addBuiltin = true;
                userRules.remove(userRules.size() - 1);
            }
            ArrayList<Object> outputRules = new ArrayList<Object>(userRules);
            if (addBuiltin) {
                outputRules.add(null);
                outputRules.addAll(builtinRules);
            }
            DimletRules.writeRules(writer, outputRules);
        }
        catch (FileNotFoundException e) {
            Logging.logError((String)"Error writing dimlets.json!");
            return;
        }
        rules = new ArrayList<Object>(userRules);
        if (addBuiltin) {
            rules.addAll(builtinRules);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Pair<Filter, Settings>> readRulesFromFile(File file) {
        try (FileInputStream inputstream = new FileInputStream(file);){
            List<Pair<Filter, Settings>> list = DimletRules.readRulesFromFile(inputstream, file.getName());
            return list;
        }
        catch (IOException e) {
            Logging.logError((String)("Error reading file: " + file.getName()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Pair<Filter, Settings>> readRulesFromFile(InputStream inputstream, String name) {
        ArrayList<Pair<Filter, Settings>> rules = new ArrayList<Pair<Filter, Settings>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            for (JsonElement entry : element.getAsJsonArray()) {
                Pair<Filter, Settings> rule = DimletRules.readRule(entry);
                if (rule == null) {
                    rules.add(null);
                    ArrayList<Pair<Filter, Settings>> arrayList = rules;
                    return arrayList;
                }
                rules.add(rule);
            }
            ArrayList<Pair<Filter, Settings>> arrayList = rules;
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Pair<Filter, Settings> readRule(JsonElement ruleElement) {
        if (ruleElement.isJsonPrimitive()) {
            return null;
        }
        JsonElement filter = ruleElement.getAsJsonObject().get("filter");
        JsonElement settings = ruleElement.getAsJsonObject().get("settings");
        if (settings == null) {
            Logging.logError((String)"Error reading dimlets.json: settings is missing");
            return null;
        }
        return DimletRules.parseRule(filter, settings);
    }

    private static Pair<Filter, Settings> parseRule(JsonElement filterElement, JsonElement settingsElement) {
        Filter filter = Filter.parse(filterElement);
        Settings settings = Settings.parse(settingsElement);
        return Pair.of((Object)filter, (Object)settings);
    }

    private static void writeRules(PrintWriter writer, List<Pair<Filter, Settings>> rules) {
        JsonArray array = new JsonArray();
        for (Pair<Filter, Settings> rule : rules) {
            if (rule == null) {
                array.add((JsonElement)new JsonPrimitive("Everything below this line will be regenerated from defaults every time. Remove this line if you do not want that"));
                continue;
            }
            JsonElement filterElement = ((Filter)rule.getLeft()).buildElement();
            JsonElement settingsElement = ((Settings)rule.getRight()).buildElement();
            JsonObject ruleObject = new JsonObject();
            if (filterElement != null) {
                ruleObject.add("filter", filterElement);
            }
            ruleObject.add("settings", settingsElement);
            array.add((JsonElement)ruleObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
    }
}

