/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.description;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.types.CelestialBodyType;
import mcjty.rftoolsdim.dimensions.types.SkyType;
import net.minecraft.nbt.NBTTagCompound;

public class SkyDescriptor {
    private final Float sunBrightnessFactor;
    private final Float starBrightnessFactor;
    private final Float skyColorFactorR;
    private final Float skyColorFactorG;
    private final Float skyColorFactorB;
    private final Float fogColorFactorR;
    private final Float fogColorFactorG;
    private final Float fogColorFactorB;
    private final Float cloudColorFactorR;
    private final Float cloudColorFactorG;
    private final Float cloudColorFactorB;
    private final SkyType skyType;
    private final List<CelestialBodyType> celestialBodies;

    private SkyDescriptor(Builder builder) {
        this.sunBrightnessFactor = builder.sunBrightnessFactor;
        this.starBrightnessFactor = builder.starBrightnessFactor;
        this.skyColorFactorR = builder.skyColorFactorR;
        this.skyColorFactorG = builder.skyColorFactorG;
        this.skyColorFactorB = builder.skyColorFactorB;
        this.fogColorFactorR = builder.fogColorFactorR;
        this.fogColorFactorG = builder.fogColorFactorG;
        this.fogColorFactorB = builder.fogColorFactorB;
        this.cloudColorFactorR = builder.cloudColorFactorR;
        this.cloudColorFactorG = builder.cloudColorFactorG;
        this.cloudColorFactorB = builder.cloudColorFactorB;
        this.skyType = builder.skyType;
        this.celestialBodies = new ArrayList<CelestialBodyType>(builder.celestialBodies);
    }

    public void toBytes(ByteBuf buf) {
        this.writeFloat(buf, this.sunBrightnessFactor);
        this.writeFloat(buf, this.starBrightnessFactor);
        this.writeFloat(buf, this.skyColorFactorR);
        this.writeFloat(buf, this.skyColorFactorG);
        this.writeFloat(buf, this.skyColorFactorB);
        this.writeFloat(buf, this.fogColorFactorR);
        this.writeFloat(buf, this.fogColorFactorG);
        this.writeFloat(buf, this.fogColorFactorB);
        this.writeFloat(buf, this.cloudColorFactorR);
        this.writeFloat(buf, this.cloudColorFactorG);
        this.writeFloat(buf, this.cloudColorFactorB);
        this.writeInteger(buf, this.skyType == null ? null : Integer.valueOf(this.skyType.ordinal()));
        buf.writeInt(this.celestialBodies.size());
        for (CelestialBodyType body : this.celestialBodies) {
            buf.writeInt(body.ordinal());
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (this.sunBrightnessFactor != null) {
            compound.func_74776_a("sunBrightness", this.sunBrightnessFactor.floatValue());
        }
        if (this.starBrightnessFactor != null) {
            compound.func_74776_a("starBrightness", this.starBrightnessFactor.floatValue());
        }
        if (this.skyColorFactorR != null) {
            compound.func_74776_a("skyColorFactorR", this.skyColorFactorR.floatValue());
        }
        if (this.skyColorFactorG != null) {
            compound.func_74776_a("skyColorFactorG", this.skyColorFactorG.floatValue());
        }
        if (this.skyColorFactorB != null) {
            compound.func_74776_a("skyColorFactorB", this.skyColorFactorB.floatValue());
        }
        if (this.fogColorFactorR != null) {
            compound.func_74776_a("fogColorFactorR", this.fogColorFactorR.floatValue());
        }
        if (this.fogColorFactorG != null) {
            compound.func_74776_a("fogColorFactorG", this.fogColorFactorG.floatValue());
        }
        if (this.fogColorFactorB != null) {
            compound.func_74776_a("fogColorFactorB", this.fogColorFactorB.floatValue());
        }
        if (this.cloudColorFactorR != null) {
            compound.func_74776_a("cloudColorFactorR", this.cloudColorFactorR.floatValue());
        }
        if (this.cloudColorFactorG != null) {
            compound.func_74776_a("cloudColorFactorG", this.cloudColorFactorG.floatValue());
        }
        if (this.cloudColorFactorB != null) {
            compound.func_74776_a("cloudColorFactorB", this.cloudColorFactorB.floatValue());
        }
        if (this.skyType != null) {
            compound.func_74768_a("skyType", this.skyType.ordinal());
        }
        int[] bodies = new int[this.celestialBodies.size()];
        for (int i = 0; i < this.celestialBodies.size(); ++i) {
            bodies[i] = this.celestialBodies.get(i).ordinal();
        }
        compound.func_74783_a("celestialBodies", bodies);
    }

    private void writeFloat(ByteBuf buf, Float value) {
        if (value == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeFloat(value.floatValue());
        }
    }

    private void writeInteger(ByteBuf buf, Integer value) {
        if (value == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(value.intValue());
        }
    }

    public float getSunBrightnessFactor() {
        return this.sunBrightnessFactor == null ? 1.0f : this.sunBrightnessFactor.floatValue();
    }

    public float getStarBrightnessFactor() {
        return this.starBrightnessFactor == null ? 1.0f : this.starBrightnessFactor.floatValue();
    }

    public float getSkyColorFactorR() {
        return this.skyColorFactorR == null ? 1.0f : this.skyColorFactorR.floatValue();
    }

    public float getSkyColorFactorG() {
        return this.skyColorFactorG == null ? 1.0f : this.skyColorFactorG.floatValue();
    }

    public float getSkyColorFactorB() {
        return this.skyColorFactorB == null ? 1.0f : this.skyColorFactorB.floatValue();
    }

    public float getFogColorFactorR() {
        return this.fogColorFactorR == null ? 1.0f : this.fogColorFactorR.floatValue();
    }

    public float getFogColorFactorG() {
        return this.fogColorFactorG == null ? 1.0f : this.fogColorFactorG.floatValue();
    }

    public float getFogColorFactorB() {
        return this.fogColorFactorB == null ? 1.0f : this.fogColorFactorB.floatValue();
    }

    public boolean isCloudColorGiven() {
        return this.cloudColorFactorR != null;
    }

    public float getCloudColorFactorR() {
        return this.cloudColorFactorR == null ? 1.0f : this.cloudColorFactorR.floatValue();
    }

    public float getCloudColorFactorG() {
        return this.cloudColorFactorG == null ? 1.0f : this.cloudColorFactorG.floatValue();
    }

    public float getCloudColorFactorB() {
        return this.cloudColorFactorB == null ? 1.0f : this.cloudColorFactorB.floatValue();
    }

    public SkyType getSkyType() {
        return this.skyType == null ? SkyType.SKY_NORMAL : this.skyType;
    }

    public boolean specifiesSkyColor() {
        return this.skyColorFactorR != null;
    }

    public boolean specifiesFogColor() {
        return this.fogColorFactorR != null;
    }

    public List<CelestialBodyType> getCelestialBodies() {
        return this.celestialBodies;
    }

    public static class Builder {
        private Float sunBrightnessFactor = null;
        private Float starBrightnessFactor = null;
        private Float skyColorFactorR = null;
        private Float skyColorFactorG = null;
        private Float skyColorFactorB = null;
        private Float fogColorFactorR = null;
        private Float fogColorFactorG = null;
        private Float fogColorFactorB = null;
        private Float cloudColorFactorR = null;
        private Float cloudColorFactorG = null;
        private Float cloudColorFactorB = null;
        private SkyType skyType;
        private List<CelestialBodyType> celestialBodies = new ArrayList<CelestialBodyType>();

        public Builder fromBytes(ByteBuf buf) {
            this.sunBrightnessFactor = this.readFloat(buf);
            this.starBrightnessFactor = this.readFloat(buf);
            this.skyColorFactorR = this.readFloat(buf);
            this.skyColorFactorG = this.readFloat(buf);
            this.skyColorFactorB = this.readFloat(buf);
            this.fogColorFactorR = this.readFloat(buf);
            this.fogColorFactorG = this.readFloat(buf);
            this.fogColorFactorB = this.readFloat(buf);
            this.cloudColorFactorR = this.readFloat(buf);
            this.cloudColorFactorG = this.readFloat(buf);
            this.cloudColorFactorB = this.readFloat(buf);
            Integer skyTypeI = this.readInteger(buf);
            this.skyType = skyTypeI == null ? null : SkyType.values()[skyTypeI];
            this.celestialBodies.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.celestialBodies.add(CelestialBodyType.values()[buf.readInt()]);
            }
            return this;
        }

        public Builder fromNBT(NBTTagCompound compound) {
            this.sunBrightnessFactor = compound.func_74764_b("sunBrightness") ? Float.valueOf(compound.func_74760_g("sunBrightness")) : null;
            this.starBrightnessFactor = compound.func_74764_b("starBrightness") ? Float.valueOf(compound.func_74760_g("starBrightness")) : null;
            this.skyColorFactorR = compound.func_74764_b("skyColorFactorR") ? Float.valueOf(compound.func_74760_g("skyColorFactorR")) : null;
            this.skyColorFactorG = compound.func_74764_b("skyColorFactorG") ? Float.valueOf(compound.func_74760_g("skyColorFactorG")) : null;
            this.skyColorFactorB = compound.func_74764_b("skyColorFactorB") ? Float.valueOf(compound.func_74760_g("skyColorFactorB")) : null;
            this.fogColorFactorR = compound.func_74764_b("fogColorFactorR") ? Float.valueOf(compound.func_74760_g("fogColorFactorR")) : null;
            this.fogColorFactorG = compound.func_74764_b("fogColorFactorG") ? Float.valueOf(compound.func_74760_g("fogColorFactorG")) : null;
            this.fogColorFactorB = compound.func_74764_b("fogColorFactorB") ? Float.valueOf(compound.func_74760_g("fogColorFactorB")) : null;
            this.cloudColorFactorR = compound.func_74764_b("cloudColorFactorR") ? Float.valueOf(compound.func_74760_g("cloudColorFactorR")) : null;
            this.cloudColorFactorG = compound.func_74764_b("cloudColorFactorG") ? Float.valueOf(compound.func_74760_g("cloudColorFactorG")) : null;
            this.cloudColorFactorB = compound.func_74764_b("cloudColorFactorB") ? Float.valueOf(compound.func_74760_g("cloudColorFactorB")) : null;
            if (compound.func_74764_b("skyType")) {
                int skyTypeI = compound.func_74762_e("skyType");
                this.skyType = SkyType.values()[skyTypeI];
            } else {
                this.skyType = null;
            }
            int[] bodies = DimensionInformation.getIntArraySafe(compound, "celestialBodies");
            this.celestialBodies.clear();
            for (int body : bodies) {
                this.celestialBodies.add(CelestialBodyType.values()[body]);
            }
            return this;
        }

        private Float readFloat(ByteBuf buf) {
            if (buf.readBoolean()) {
                return Float.valueOf(buf.readFloat());
            }
            return null;
        }

        private Integer readInteger(ByteBuf buf) {
            if (buf.readBoolean()) {
                return buf.readInt();
            }
            return null;
        }

        public Builder combine(SkyDescriptor descriptor) {
            Object object;
            if (descriptor.starBrightnessFactor != null) {
                this.starBrightnessFactor(descriptor.getStarBrightnessFactor());
            }
            if (descriptor.sunBrightnessFactor != null) {
                this.sunBrightnessFactor(descriptor.getSunBrightnessFactor());
            }
            if (descriptor.skyType != null) {
                this.skyType(descriptor.skyType);
            }
            if (descriptor.skyColorFactorR != null) {
                if (this.skyColorFactorR == null) {
                    this.skyColorFactorR = descriptor.skyColorFactorR;
                } else {
                    object = this;
                    ((Builder)object).skyColorFactorR = Float.valueOf(((Builder)object).skyColorFactorR.floatValue() * descriptor.skyColorFactorR.floatValue());
                }
            }
            if (descriptor.skyColorFactorG != null) {
                if (this.skyColorFactorG == null) {
                    this.skyColorFactorG = descriptor.skyColorFactorG;
                } else {
                    object = this;
                    ((Builder)object).skyColorFactorG = Float.valueOf(((Builder)object).skyColorFactorG.floatValue() * descriptor.skyColorFactorG.floatValue());
                }
            }
            if (descriptor.skyColorFactorB != null) {
                if (this.skyColorFactorB == null) {
                    this.skyColorFactorB = descriptor.skyColorFactorB;
                } else {
                    object = this;
                    ((Builder)object).skyColorFactorB = Float.valueOf(((Builder)object).skyColorFactorB.floatValue() * descriptor.skyColorFactorB.floatValue());
                }
            }
            if (descriptor.fogColorFactorR != null) {
                if (this.fogColorFactorR == null) {
                    this.fogColorFactorR = descriptor.fogColorFactorR;
                } else {
                    object = this;
                    ((Builder)object).fogColorFactorR = Float.valueOf(((Builder)object).fogColorFactorR.floatValue() * descriptor.fogColorFactorR.floatValue());
                }
            }
            if (descriptor.fogColorFactorG != null) {
                if (this.fogColorFactorG == null) {
                    this.fogColorFactorG = descriptor.fogColorFactorG;
                } else {
                    object = this;
                    ((Builder)object).fogColorFactorG = Float.valueOf(((Builder)object).fogColorFactorG.floatValue() * descriptor.fogColorFactorG.floatValue());
                }
            }
            if (descriptor.fogColorFactorB != null) {
                if (this.fogColorFactorB == null) {
                    this.fogColorFactorB = descriptor.fogColorFactorB;
                } else {
                    object = this;
                    ((Builder)object).fogColorFactorB = Float.valueOf(((Builder)object).fogColorFactorB.floatValue() * descriptor.fogColorFactorB.floatValue());
                }
            }
            if (descriptor.cloudColorFactorR != null) {
                if (this.cloudColorFactorR == null) {
                    this.cloudColorFactorR = descriptor.cloudColorFactorR;
                } else {
                    object = this;
                    ((Builder)object).cloudColorFactorR = Float.valueOf(((Builder)object).cloudColorFactorR.floatValue() * descriptor.cloudColorFactorR.floatValue());
                }
            }
            if (descriptor.cloudColorFactorG != null) {
                if (this.cloudColorFactorG == null) {
                    this.cloudColorFactorG = descriptor.cloudColorFactorG;
                } else {
                    object = this;
                    ((Builder)object).cloudColorFactorG = Float.valueOf(((Builder)object).cloudColorFactorG.floatValue() * descriptor.cloudColorFactorG.floatValue());
                }
            }
            if (descriptor.cloudColorFactorB != null) {
                if (this.cloudColorFactorB == null) {
                    this.cloudColorFactorB = descriptor.cloudColorFactorB;
                } else {
                    object = this;
                    ((Builder)object).cloudColorFactorB = Float.valueOf(((Builder)object).cloudColorFactorB.floatValue() * descriptor.cloudColorFactorB.floatValue());
                }
            }
            for (CelestialBodyType body : descriptor.celestialBodies) {
                if (body == CelestialBodyType.BODY_NONE || body == CelestialBodyType.BODY_NORMAL) {
                    this.celestialBodies.clear();
                }
                if (body == CelestialBodyType.BODY_NORMAL) continue;
                this.celestialBodies.add(body);
            }
            return this;
        }

        public Builder skyType(SkyType t) {
            this.skyType = t;
            return this;
        }

        public Builder resetSkytype() {
            this.skyType = null;
            return this;
        }

        public Builder sunBrightnessFactor(float f) {
            this.sunBrightnessFactor = Float.valueOf(f);
            return this;
        }

        public Builder starBrightnessFactor(float f) {
            this.starBrightnessFactor = Float.valueOf(f);
            return this;
        }

        public Builder skyColorFactor(float r, float g, float b) {
            this.skyColorFactorR = Float.valueOf(r);
            this.skyColorFactorG = Float.valueOf(g);
            this.skyColorFactorB = Float.valueOf(b);
            return this;
        }

        public Builder resetSkyColor() {
            this.skyColorFactorR = null;
            this.skyColorFactorG = null;
            this.skyColorFactorB = null;
            return this;
        }

        public Builder fogColorFactor(float r, float g, float b) {
            this.fogColorFactorR = Float.valueOf(r);
            this.fogColorFactorG = Float.valueOf(g);
            this.fogColorFactorB = Float.valueOf(b);
            return this;
        }

        public Builder resetFogColor() {
            this.fogColorFactorR = null;
            this.fogColorFactorG = null;
            this.fogColorFactorB = null;
            return this;
        }

        public Builder cloudColorFactor(float r, float g, float b) {
            this.cloudColorFactorR = Float.valueOf(r);
            this.cloudColorFactorG = Float.valueOf(g);
            this.cloudColorFactorB = Float.valueOf(b);
            return this;
        }

        public Builder resetCloudColor() {
            this.cloudColorFactorR = null;
            this.cloudColorFactorG = null;
            this.cloudColorFactorB = null;
            return this;
        }

        public Builder addBody(CelestialBodyType body) {
            this.celestialBodies.add(body);
            return this;
        }

        public SkyDescriptor build() {
            return new SkyDescriptor(this);
        }
    }
}

