/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005JH\u0010\u000f\u001a$\u0012\f\u0012\n \u0012*\u0004\u0018\u0001H\u0011H\u0011 \u0012*\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u0001H\u0011H\u00110\u00130\u0010\"\b\b\u0000\u0010\u0011*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0096\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\""}, d2={"Lnet/ndrei/teslacorelib/utils/BlockCube;", "", "Lnet/minecraft/util/math/BlockPos;", "pos1", "pos2", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)V", "boundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "getBoundingBox", "()Lnet/minecraft/util/math/AxisAlignedBB;", "northWest", "getNorthWest", "()Lnet/minecraft/util/math/BlockPos;", "southEast", "getSouthEast", "findEntities", "", "T", "kotlin.jvm.PlatformType", "", "Lnet/minecraft/entity/Entity;", "entityClass", "Ljava/lang/Class;", "world", "Lnet/minecraft/world/World;", "getRandomInside", "rnd", "Ljava/util/Random;", "iterator", "", "pickItemEntities", "Lnet/minecraft/item/ItemStack;", "BlockPosIterator", "Companion", "tesla-core-lib"})
public final class BlockCube
implements Iterable<BlockPos>,
KMappedMarker {
    @NotNull
    private final BlockPos southEast;
    @NotNull
    private final BlockPos northWest;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final BlockPos getSouthEast() {
        return this.southEast;
    }

    @NotNull
    public final BlockPos getNorthWest() {
        return this.northWest;
    }

    @NotNull
    public final BlockPos getRandomInside(@Nullable Random rnd) {
        int x = this.southEast.func_177958_n() - this.northWest.func_177958_n();
        int y = this.southEast.func_177956_o() - this.northWest.func_177956_o();
        int z = this.southEast.func_177952_p() - this.northWest.func_177952_p();
        Random random = rnd;
        if (random == null) {
            random = new Random();
        }
        Random rand = random;
        return new BlockPos(this.northWest.func_177958_n() + Math.round(rand.nextFloat() * (float)x), this.northWest.func_177956_o() + Math.round(rand.nextFloat() * (float)y), this.northWest.func_177952_p() + Math.round(rand.nextFloat() * (float)z));
    }

    @NotNull
    public final AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB((double)this.northWest.func_177958_n(), (double)this.northWest.func_177956_o(), (double)this.northWest.func_177952_p(), (double)(this.southEast.func_177958_n() + 1), (double)(this.southEast.func_177956_o() + 1), (double)(this.southEast.func_177952_p() + 1));
    }

    @Override
    @NotNull
    public Iterator<BlockPos> iterator() {
        return new BlockPosIterator(this);
    }

    @NotNull
    public final <T extends Entity> List<T> findEntities(@NotNull Class<T> entityClass, @NotNull World world) {
        Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        List list = world.func_72872_a(entityClass, this.getBoundingBox());
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @NotNull
    public final List<ItemStack> pickItemEntities(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        List stacks = new ArrayList();
        Iterator<EntityItem> iterator = this.findEntities(EntityItem.class, world).iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            EntityItem entity;
            EntityItem entityItem = entity = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entityItem, (String)"entity");
            ItemStack itemStack = stack = entityItem.func_92059_d();
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.func_190926_b()) {
                stacks.add(stack);
            }
            world.func_72900_e((Entity)entity);
        }
        return CollectionsKt.toList((Iterable)stacks);
    }

    public BlockCube(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos1, (String)"pos1");
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos2");
        this.southEast = new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
        this.northWest = new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/ndrei/teslacorelib/utils/BlockCube$BlockPosIterator;", "", "Lnet/minecraft/util/math/BlockPos;", "cube", "Lnet/ndrei/teslacorelib/utils/BlockCube;", "(Lnet/ndrei/teslacorelib/utils/BlockCube;Lnet/ndrei/teslacorelib/utils/BlockCube;)V", "maxX", "", "maxY", "maxZ", "minX", "minY", "minZ", "position", "xSize", "ySize", "zSize", "hasNext", "", "next", "tesla-core-lib"})
    private final class BlockPosIterator
    implements Iterator<BlockPos>,
    KMappedMarker {
        private int position;
        private final int minX;
        private final int minY;
        private final int minZ;
        private final int maxX;
        private final int maxY;
        private final int maxZ;
        private final int xSize;
        private final int ySize;
        private final int zSize;

        @Override
        public boolean hasNext() {
            return this.position < this.xSize * this.ySize * this.zSize;
        }

        @Override
        @NotNull
        public BlockPos next() {
            int plane = this.position % (this.xSize * this.zSize);
            int y = this.position / (this.xSize * this.zSize);
            int x = plane % this.zSize;
            int z = plane / this.zSize;
            int n = this.position;
            this.position = n + 1;
            return new BlockPos(this.minX + x, this.minY + y, this.minZ + z);
        }

        public BlockPosIterator(BlockCube cube) {
            Intrinsics.checkParameterIsNotNull((Object)cube, (String)"cube");
            this.minX = cube.getNorthWest().func_177958_n();
            this.minY = cube.getNorthWest().func_177956_o();
            this.minZ = cube.getNorthWest().func_177952_p();
            this.maxX = cube.getSouthEast().func_177958_n();
            this.maxY = cube.getSouthEast().func_177956_o();
            this.maxZ = cube.getSouthEast().func_177952_p();
            this.xSize = this.maxX - this.minX + 1;
            this.ySize = this.maxY - this.minY + 1;
            this.zSize = this.maxZ - this.minZ + 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lnet/ndrei/teslacorelib/utils/BlockCube$Companion;", "", "()V", "pickItemEntities", "", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "radius", "", "tesla-core-lib"})
    public static final class Companion {
        @NotNull
        public final List<ItemStack> pickItemEntities(@NotNull World world, @NotNull BlockPos pos, int radius) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            BlockPos blockPos = pos.func_177965_g(radius).func_177970_e(radius).func_177979_c(radius);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.east(radius).south(radius).down(radius)");
            BlockPos blockPos2 = pos.func_177985_f(radius).func_177964_d(radius).func_177981_b(radius);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.west(radius).north(radius).up(radius)");
            return new BlockCube(blockPos, blockPos2).pickItemEntities(world);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

