/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumicenergistics.block.BlockBase;
import thaumicenergistics.tile.TileNetwork;

public abstract class BlockNetwork
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockNetwork(String id) {
        this(id, Material.field_151573_f);
    }

    public BlockNetwork(String id, Material material) {
        super(id, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileNetwork && placer instanceof EntityPlayer) {
            TileNetwork tn = (TileNetwork)te;
            tn.setOwner((EntityPlayer)placer);
            tn.getActionableNode();
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, ACTIVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean powered = false;
        boolean active = false;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileNetwork) {
            TileNetwork tn = (TileNetwork)te;
            powered = tn.isPowered();
            active = tn.isActive();
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }
}

