/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.helpers;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEStack;
import appeng.integration.Integrations;
import appeng.integration.abstraction.IInvTweaks;
import appeng.util.Platform;
import java.util.Comparator;
import thaumicenergistics.util.AEUtil;

public class ThEItemSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEStack<?>> CONFIG_BASED_SORT_BY_NAME = (o1, o2) -> {
        int cmp = AEUtil.getDisplayName(o1).compareToIgnoreCase(AEUtil.getDisplayName(o2));
        return ThEItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEStack<?>> CONFIG_BASED_SORT_BY_MOD = (o1, o2) -> {
        int cmp = AEUtil.getModID(o1).compareToIgnoreCase(AEUtil.getModID(o2));
        if (cmp == 0) {
            cmp = Platform.getItemDisplayName((Object)o1).compareToIgnoreCase(Platform.getItemDisplayName((Object)o2));
        }
        return ThEItemSorters.applyDirection(cmp);
    };
    public static final Comparator<IAEStack<?>> CONFIG_BASED_SORT_BY_SIZE = (o1, o2) -> {
        int cmp = Long.compare(o2.getStackSize(), o1.getStackSize());
        return ThEItemSorters.applyDirection(cmp);
    };
    private static IInvTweaks api;
    public static final Comparator<IAEStack<?>> CONFIG_BASED_SORT_BY_INV_TWEAKS;

    public static void init() {
        if (api != null) {
            return;
        }
        api = Integrations.invTweaks().isEnabled() ? Integrations.invTweaks() : null;
    }

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }

    private static int applyDirection(int cmp) {
        if (ThEItemSorters.getDirection() == SortDir.ASCENDING) {
            return cmp;
        }
        return -cmp;
    }

    static {
        CONFIG_BASED_SORT_BY_INV_TWEAKS = (o1, o2) -> {
            if (api == null) {
                return CONFIG_BASED_SORT_BY_NAME.compare((IAEStack<?>)o1, (IAEStack<?>)o2);
            }
            int cmp = api.compareItems(o1.asItemStackRepresentation(), o2.asItemStackRepresentation());
            return ThEItemSorters.applyDirection(cmp);
        };
    }
}

