/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import appeng.api.config.Settings;
import appeng.api.util.IConfigurableObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import thaumicenergistics.config.AESettings;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.integration.appeng.util.ThEConfigManager;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketSettingChange;
import thaumicenergistics.util.ForgeUtil;

public abstract class ContainerBaseConfigurable
extends ContainerBase
implements IConfigurableObject {
    protected ThEConfigManager serverConfigManager;
    protected ThEConfigManager clientConfigManager = new ThEConfigManager();

    public ContainerBaseConfigurable(EntityPlayer player, ThEConfigManager serverConfigManager) {
        super(player);
        this.clientConfigManager.registerSettings(this.getAESettingSubject());
        if (ForgeUtil.isServer()) {
            this.serverConfigManager = serverConfigManager;
        }
    }

    protected abstract AESettings.SUBJECT getAESettingSubject();

    public void func_75142_b() {
        if (ForgeUtil.isServer()) {
            if (this.field_75149_d.isEmpty()) {
                return;
            }
            for (Settings setting : this.serverConfigManager.getSettings()) {
                Enum<?> server = this.serverConfigManager.getSetting(setting);
                Enum<?> client = this.clientConfigManager.getSetting(setting);
                if (client == server) continue;
                this.clientConfigManager.putSetting(setting, server);
                for (IContainerListener player : this.field_75149_d) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    PacketHandler.sendToPlayer((EntityPlayerMP)player, new PacketSettingChange(setting, server));
                }
            }
        }
        super.func_75142_b();
    }

    public ThEConfigManager getConfigManager() {
        return ForgeUtil.isClient() ? this.clientConfigManager : this.serverConfigManager;
    }
}

