/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packets;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumicenergistics.client.gui.part.GuiArcaneInscriber;
import thaumicenergistics.client.gui.part.GuiArcaneTerminal;
import thaumicenergistics.util.ThELog;

public class PacketMEItemUpdate
implements IMessage {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    private static final int OPERATION_BYTE_LIMIT = 2048;
    private static final int TEMP_BUFFER_SIZE = 1024;
    private final List<IAEItemStack> list = new ArrayList<IAEItemStack>();
    private final ByteBuf data = Unpooled.buffer((int)2048);
    private final GZIPOutputStream compressFrame = new GZIPOutputStream(new OutputStream(){

        @Override
        public void write(int value) {
            PacketMEItemUpdate.this.data.writeByte(value);
        }
    });
    private int writtenBytes = 0;
    private boolean empty = true;

    public void fromBytes(final ByteBuf buf) {
        if (!buf.isReadable()) {
            return;
        }
        try (GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                if (buf.readableBytes() <= 0) {
                    return -1;
                }
                return buf.readByte() & 0xFF;
            }
        });){
            ByteBuf uncompressed = Unpooled.buffer((int)buf.readableBytes());
            byte[] tmp = new byte[1024];
            while (gzReader.available() != 0) {
                int bytes = gzReader.read(tmp);
                if (bytes <= 0) continue;
                uncompressed.writeBytes(tmp, 0, bytes);
            }
            while (uncompressed.readableBytes() > 0) {
                this.list.add((IAEItemStack)AEItemStack.fromPacket((ByteBuf)uncompressed));
            }
        }
        catch (IOException e) {
            ThELog.error("fromBytes IOException", e);
        }
        this.empty = this.list.isEmpty();
    }

    public void toBytes(ByteBuf buf) {
        if (!this.data.isReadable()) {
            ThELog.info("No readable bytes, skipping", new Object[0]);
            return;
        }
        try {
            this.compressFrame.close();
            this.data.capacity(this.data.readableBytes());
            if (this.data.array().length > 0x200000) {
                throw new IllegalArgumentException("Sorry, ThE made a " + this.data.array().length + " byte packet by accident!");
            }
            buf.writeBytes(this.data);
        }
        catch (IOException e) {
            ThELog.error("toBytes IOException", e);
        }
    }

    public void appendStack(IAEItemStack stack) throws IOException, BufferOverflowException {
        ByteBuf tmp = Unpooled.buffer((int)2048);
        stack.writeToPacket(tmp);
        this.compressFrame.flush();
        if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
            throw new BufferOverflowException();
        }
        this.writtenBytes += tmp.readableBytes();
        this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        this.empty = false;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public static class Handler
    implements IMessageHandler<PacketMEItemUpdate, IMessage> {
        public IMessage onMessage(PacketMEItemUpdate message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                GuiArcaneTerminal gui;
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiArcaneTerminal) {
                    gui = (GuiArcaneTerminal)Minecraft.func_71410_x().field_71462_r;
                    gui.onMEStorageUpdate(message.list);
                }
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiArcaneInscriber) {
                    gui = (GuiArcaneInscriber)Minecraft.func_71410_x().field_71462_r;
                    gui.onMEStorageUpdate(message.list);
                }
            });
            return null;
        }
    }
}

