/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.config.AESettings;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.ThEPartModel;
import thaumicenergistics.item.part.ItemArcaneTerminal;
import thaumicenergistics.part.PartSharedTerminal;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.ItemHandlerUtil;
import thaumicenergistics.util.inventory.ThEInternalInventory;
import thaumicenergistics.util.inventory.ThEUpgradeInventory;

public class PartArcaneTerminal
extends PartSharedTerminal {
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("thaumicenergistics", "part/arcane_terminal/base"), new ResourceLocation("thaumicenergistics", "part/arcane_terminal/on"), new ResourceLocation("thaumicenergistics", "part/arcane_terminal/off"), new ResourceLocation("appliedenergistics2", "part/display_status_has_channel"), new ResourceLocation("appliedenergistics2", "part/display_status_on"), new ResourceLocation("appliedenergistics2", "part/display_status_off")};
    private static final IPartModel MODEL_ON = new ThEPartModel(MODELS[0], MODELS[1], MODELS[4]);
    private static final IPartModel MODEL_OFF = new ThEPartModel(MODELS[0], MODELS[2], MODELS[5]);
    private static final IPartModel MODEL_HAS_CHANNEL = new ThEPartModel(MODELS[0], MODELS[1], MODELS[3]);
    protected ThEInternalInventory craftingInventory = new ThEInternalInventory("matrix", 15, 64);
    protected ThEInternalInventory upgradeInventory = new ThEUpgradeInventory("upgrades", 1, 1, this.getItemStack(PartItemStack.NETWORK));

    public PartArcaneTerminal(ItemArcaneTerminal item) {
        this(item, ModGUIs.ARCANE_TERMINAL);
    }

    public PartArcaneTerminal(ItemArcaneTerminal item, ModGUIs gui) {
        super(item, gui);
    }

    @Override
    protected AESettings.SUBJECT getAESettingSubject() {
        return AESettings.SUBJECT.ARCANE_TERMINAL;
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equalsIgnoreCase("crafting")) {
            return new InvWrapper((IInventory)this.craftingInventory);
        }
        if (name.equalsIgnoreCase("upgrades")) {
            return new InvWrapper((IInventory)this.upgradeInventory);
        }
        return super.getInventoryByName(name);
    }

    @Override
    public void getDrops(List<ItemStack> list, boolean b) {
        super.getDrops(list, b);
        list.addAll(ItemHandlerUtil.getInventoryAsList(this.getInventoryByName("crafting")));
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (player.func_70093_af() && AEUtil.isWrench(player.func_184586_b(hand), player, this.getTile().func_174877_v())) {
            return false;
        }
        if (ForgeUtil.isServer()) {
            GuiHandler.openGUI(this.getGui(), player, this.hostTile.func_174877_v(), this.side);
        }
        this.host.markForUpdate();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("crafting", (NBTBase)this.craftingInventory.serializeNBT());
        tag.func_74782_a("upgrades", (NBTBase)this.upgradeInventory.serializeNBT());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.func_74764_b("crafting")) {
            this.craftingInventory.deserializeNBT(tag.func_150295_c("crafting", 10));
        }
        if (tag.func_74764_b("upgrades")) {
            this.upgradeInventory.deserializeNBT(tag.func_150295_c("upgrades", 10));
        }
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODEL_HAS_CHANNEL;
            }
            return MODEL_ON;
        }
        return MODEL_OFF;
    }
}

