/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AECableType;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.client.gui.GuiHandler;
import thaumicenergistics.config.AESettings;
import thaumicenergistics.init.ModGUIs;
import thaumicenergistics.integration.appeng.ThEPartModel;
import thaumicenergistics.integration.appeng.grid.EssentiaContainerAdapter;
import thaumicenergistics.item.part.ItemEssentiaStorageBus;
import thaumicenergistics.part.PartSharedEssentiaBus;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.ForgeUtil;

public class PartEssentiaStorageBus
extends PartSharedEssentiaBus
implements ICellContainer,
IMEMonitorHandlerReceiver<IAEEssentiaStack>,
IPriorityHost {
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("thaumicenergistics", "part/essentia_storage_bus/base"), new ResourceLocation("thaumicenergistics", "part/essentia_storage_bus/on"), new ResourceLocation("thaumicenergistics", "part/essentia_storage_bus/off"), new ResourceLocation("thaumicenergistics", "part/essentia_storage_bus/has_channel")};
    private static final IPartModel MODEL_ON = new ThEPartModel(MODELS[0], MODELS[1]);
    private static final IPartModel MODEL_OFF = new ThEPartModel(MODELS[0], MODELS[2]);
    private static final IPartModel MODEL_HAS_CHANNEL = new ThEPartModel(MODELS[0], MODELS[3]);
    private EssentiaContainerAdapter handler;
    private boolean wasActive = false;
    private IAspectContainer lastConnectedContainer = null;
    private int priority = 0;

    public PartEssentiaStorageBus(ItemEssentiaStorageBus item) {
        super(item, 63, 5);
    }

    @Override
    protected AESettings.SUBJECT getAESettingSubject() {
        return AESettings.SUBJECT.ESSENTIA_STORAGE_BUS;
    }

    @Override
    public void settingChanged(Settings setting) {
        super.settingChanged(setting);
        EssentiaContainerAdapter handler = this.handler;
        if (handler != null) {
            if (setting == Settings.ACCESS) {
                handler.setBaseAccess((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
            } else if (setting == Settings.STORAGE_FILTER) {
                handler.setReportInaccessible((StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER));
            } else {
                return;
            }
            this.triggerUpdate();
        }
    }

    protected void upgradesChanged() {
        EssentiaContainerAdapter handler = this.getHandler();
        if (handler != null) {
            handler.setWhitelist(!this.hasInverterCard());
        }
        this.triggerUpdate();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.lastConnectedContainer = this.getConnectedContainer();
        this.upgradeChangeListeners.add(this::upgradesChanged);
        this.upgradesChanged();
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.upgradeChangeListeners.clear();
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(ThEApi.instance().config().tickTimeEssentiaStorageBusMin(), ThEApi.instance().config().tickTimeEssentiaStorageBusMax(), false, false);
    }

    @Override
    public boolean canWork() {
        return false;
    }

    @Override
    protected TickRateModulation doWork() {
        return TickRateModulation.SLOWER;
    }

    public void postChange(IBaseMonitor<IAEEssentiaStack> monitor, Iterable<IAEEssentiaStack> change, IActionSource actionSource) {
    }

    public void onListUpdate() {
    }

    public void saveChanges(ICellInventory<?> iCellInventory) {
    }

    @Override
    public void onNeighborChanged(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        IAspectContainer connectedContainer;
        IGrid grid;
        if (pos == null || neighbor == null) {
            return;
        }
        if (pos.func_177972_a(this.side.getFacing()).equals((Object)neighbor) && this.getGridNode() != null && (grid = this.getGridNode().getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        if (this.lastConnectedContainer != (connectedContainer = this.getConnectedContainer())) {
            this.lastConnectedContainer = connectedContainer;
            this.handler = null;
        }
        super.onNeighborChanged(access, pos, neighbor);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d vec3d) {
        if (player.func_70093_af() && AEUtil.isWrench(player.func_184586_b(hand), player, this.getTile().func_174877_v())) {
            return false;
        }
        if (ForgeUtil.isServer()) {
            GuiHandler.openGUI(ModGUIs.ESSENTIA_STORAGE_BUS, player, this.hostTile.func_174877_v(), this.side);
        }
        return true;
    }

    public void blinkCell(int slot) {
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (channel != this.getChannel() || this.getHandler() == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getHandler());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int i) {
        this.priority = i;
        if (this.handler != null) {
            this.handler.setPriority(i);
        }
        this.host.markForSave();
    }

    public ItemStack getItemStackRepresentation() {
        return this.getRepr();
    }

    public GuiBridge getGuiBridge() {
        return null;
    }

    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return MODEL_HAS_CHANNEL;
            }
            return MODEL_ON;
        }
        return MODEL_OFF;
    }

    @Nullable
    private EssentiaContainerAdapter getHandler() {
        if (this.handler == null) {
            IAspectContainer connectedContainer = this.getConnectedContainer();
            if (connectedContainer != null) {
                this.handler = new EssentiaContainerAdapter(connectedContainer, this.config, !this.hasInverterCard(), (AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS), (StorageFilter)this.getConfigManager().getSetting(Settings.STORAGE_FILTER), this.priority);
                return this.handler;
            }
            return null;
        }
        return this.handler;
    }

    private IAspectContainer getConnectedContainer() {
        return this.getConnectedTE() instanceof IAspectContainer ? (IAspectContainer)this.getConnectedTE() : null;
    }

    @Override
    public void getBoxes(IPartCollisionHelper box) {
        box.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        box.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        box.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public float getCableConnectionLength(AECableType aeCableType) {
        return 4.0f;
    }

    @Override
    @MENetworkEventSubscribe
    public void updateBootStatus(MENetworkBootingStatusChange event) {
        super.updateBootStatus(event);
        this.triggerBootUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void updatePowerStatus(MENetworkPowerStatusChange event) {
        super.updatePowerStatus(event);
        this.triggerBootUpdate();
    }

    public void triggerBootUpdate() {
        boolean currentActive = this.getGridNode().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.triggerUpdate();
        }
    }

    public void triggerUpdate() {
        this.gridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        this.host.markForUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.priority = tag.func_74762_e("priority");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("priority", this.priority);
    }
}

