/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer;

import com.nekokittygames.thaumictinkerer.api.ThaumicTinkererAPI;
import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.commands.CommandDumpEnchants;
import com.nekokittygames.thaumictinkerer.common.commands.CommandRefreshMultiblocks;
import com.nekokittygames.thaumictinkerer.common.compat.botania.BotaniaCompat;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectDislocate;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectTelekenesis;
import com.nekokittygames.thaumictinkerer.common.misc.ThaumicTInkererCreativeTab;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockManager;
import com.nekokittygames.thaumictinkerer.common.packets.PacketHandler;
import com.nekokittygames.thaumictinkerer.common.proxy.ITTProxy;
import com.nekokittygames.thaumictinkerer.common.research.theorycraft.AidBlackQuartz;
import com.nekokittygames.thaumictinkerer.common.research.theorycraft.CardExperience;
import java.io.IOException;
import java.net.URISyntaxException;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.TheorycraftManager;

@Mod(modid="thaumictinkerer", name="Thaumic Tinkerer", version="1.12.2-5.0-620a0c5", dependencies="required-after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class ThaumicTinkerer {
    public static Logger logger;
    private static CreativeTabs tab;
    @SidedProxy(serverSide="com.nekokittygames.thaumictinkerer.common.proxy.CommonProxy", clientSide="com.nekokittygames.thaumictinkerer.client.proxy.ClientProxy")
    public static ITTProxy proxy;
    @Mod.Instance(value="thaumictinkerer")
    public static ThaumicTinkerer instance;

    public static CreativeTabs getTab() {
        return tab;
    }

    public static void setTab(CreativeTabs tab) {
        ThaumicTinkerer.tab = tab;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        tab = new ThaumicTInkererCreativeTab();
        logger = event.getModLog();
        proxy.preInit(event);
        PacketHandler.registerMessages("thaumictinkerer");
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRefreshMultiblocks());
        event.registerServerCommand((ICommand)new CommandDumpEnchants());
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equalsIgnoreCase("addDislocateBlacklist") && message.isStringMessage()) {
                ThaumicTinkererAPI.getDislocationBlacklist().add(message.getStringValue());
            }
            if (!message.key.equalsIgnoreCase("addTabletBlacklist") || !message.isStringMessage()) continue;
            ThaumicTinkererAPI.getAnimationTabletBlacklist().add(message.getStringValue());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MultiblockManager.initMultiblocks();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        proxy.init(event);
        ResearchCategories.registerCategory((String)"THAUMIC_TINKERER", null, (AspectList)new AspectList(), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/items/share_book.png"), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/misc/sky1.png"), (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/misc/sky1.png"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/misc"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/baubles"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/machines"));
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumictinkerer", "research/foci"));
        TheorycraftManager.registerCard(CardExperience.class);
        TheorycraftManager.registerAid((ITheorycraftAid)new AidBlackQuartz(ModBlocks.black_quartz_block));
        BotaniaCompat.addTheorycraft();
        proxy.registerRenderers();
        this.initFoci();
    }

    private void initFoci() {
        if (TTConfig.DislocationFocusEnabled) {
            FocusEngine.registerElement(FocusEffectDislocate.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/dislocation.png"), (int)15121988);
        }
        if (TTConfig.TelekenesisFocusEnabled) {
            logger.info("Initializing Telekenetic powers");
            FocusEngine.registerElement(FocusEffectTelekenesis.class, (ResourceLocation)new ResourceLocation("thaumictinkerer", "textures/foci_icons/telekenesis.png"), (int)0xCF00FF);
        }
    }
}

