/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.gui.button;

import com.nekokittygames.thaumictinkerer.client.gui.button.GuiTexturedButton;
import com.nekokittygames.thaumictinkerer.client.gui.button.IRadioButton;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class GuiTexturedRadioButton
extends GuiTexturedButton
implements IRadioButton {
    private final List<IRadioButton> linkedButtons;
    private final String groupName;

    public GuiTexturedRadioButton(int buttonId, int x, int y, ResourceLocation textureLocation, boolean enabled, String group, List<IRadioButton> linkedButtons) {
        super(buttonId, x, y, textureLocation, enabled);
        this.linkedButtons = linkedButtons;
        this.groupName = group;
    }

    public GuiTexturedRadioButton(int buttonId, int x, int y, ResourceLocation textureLocation, boolean enabled, List<IRadioButton> linkedButtons) {
        super(buttonId, x, y, textureLocation, enabled);
        this.linkedButtons = linkedButtons;
        this.groupName = "default";
    }

    @Override
    public String getGroup() {
        return this.groupName;
    }

    @Override
    public void enableFromClick() {
        this.setEnabled(true);
        for (IRadioButton button : this.linkedButtons) {
            if (button == this || !this.groupName.equals(button.getGroup())) continue;
            button.updateStatus(this);
        }
    }

    @Override
    public void updateStatus(IRadioButton otherButton) {
        if (otherButton.isEnabled() && this.groupName.equals(otherButton.getGroup())) {
            this.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isButtonEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setButtonEnabled(enabled);
    }
}

