/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.blocks;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.blocks.TTTileEntity;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityMagnet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMagnet<T extends TileEntityMagnet>
extends TTTileEntity<T> {
    private static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyEnum<MagnetPull> POLE = PropertyEnum.func_177709_a((String)"pole", MagnetPull.class);

    protected BlockMagnet(String name) {
        super(name, Material.field_151573_f, true);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(POLE, (Comparable)((Object)MagnetPull.PULL)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POLE, FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)Objects.requireNonNull(BlockPistonBase.func_176317_b((int)meta))).func_177226_a(POLE, (Comparable)((Object)((meta & 8) > 0 ? MagnetPull.PUSH : MagnetPull.PULL)));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (state.func_177229_b(POLE) == MagnetPull.PULL) {
            i |= 8;
        }
        return i;
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return super.rotateBlock(world, pos, axis);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a(POLE, (Comparable)((Object)MagnetPull.PULL));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityMagnet)) {
            return false;
        }
        player.openGui((Object)ThaumicTinkerer.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public static enum MagnetType implements IStringSerializable
    {
        ITEM("item"),
        MOB("mob");

        private String name;

        private MagnetType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum MagnetPull implements IStringSerializable
    {
        PULL("pull"),
        PUSH("push");

        private String name;

        private MagnetPull(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

