/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.tileentity.transvector.TileEntityTransvector;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemConnector
extends TTItem {
    private static final String TAG_X_TARGET = "xt";
    private static final String TAG_Y_TARGET = "yt";
    private static final String TAG_Z_TARGET = "zt";

    public ItemConnector() {
        super("connector");
    }

    public static BlockPos getTarget(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        if (cmp.func_74764_b(TAG_X_TARGET)) {
            return new BlockPos(cmp.func_74762_e(TAG_X_TARGET), cmp.func_74762_e(TAG_Y_TARGET), cmp.func_74762_e(TAG_Z_TARGET));
        }
        return null;
    }

    public static void setTarget(ItemStack stack, BlockPos pos) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        cmp.func_74768_a(TAG_X_TARGET, pos.func_177958_n());
        cmp.func_74768_a(TAG_Y_TARGET, pos.func_177956_o());
        cmp.func_74768_a(TAG_Z_TARGET, pos.func_177952_p());
    }

    public static void clearTarget(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        cmp.func_82580_o(TAG_X_TARGET);
        cmp.func_82580_o(TAG_Y_TARGET);
        cmp.func_82580_o(TAG_Z_TARGET);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack;
        BlockPos target;
        RayTraceResult result = this.func_77621_a(worldIn, playerIn, false);
        if ((result == null || result != null && result.field_72313_a == RayTraceResult.Type.MISS && playerIn.func_70093_af()) && (target = ItemConnector.getTarget(stack = playerIn.func_184586_b(handIn))) != null) {
            ItemConnector.clearTarget(stack);
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.clear", new Object[0]), true);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        BlockPos target = ItemConnector.getTarget(stack);
        if (target == null) {
            if (tile instanceof TileEntityTransvector) {
                ItemConnector.setTarget(stack, pos);
                if (!worldIn.field_72995_K) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_187604_bf, SoundCategory.MASTER, 0.8f, 1.0f);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.set", new Object[0]), true);
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            TileEntity te2 = worldIn.func_175625_s(target);
            if (!(te2 instanceof TileEntityTransvector)) {
                ItemConnector.clearTarget(stack);
                if (!worldIn.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.notpresent", new Object[0]), true);
                }
                return EnumActionResult.FAIL;
            }
            TileEntityTransvector trans = (TileEntityTransvector)te2;
            if (tile instanceof TileEntityTransvector) {
                if (!worldIn.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.interffail", new Object[0]), true);
                }
                return EnumActionResult.FAIL;
            }
            if (!trans.setTilePos(pos)) {
                if (!worldIn.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.toofar", new Object[0]), true);
                }
                return EnumActionResult.FAIL;
            }
            ItemConnector.clearTarget(stack);
            if (!worldIn.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.connector.complete", new Object[0]), true);
                worldIn.func_184133_a(player, pos, SoundEvents.field_187604_bf, SoundCategory.MASTER, 0.8f, 1.0f);
            }
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }
}

