/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.packets;

import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityAnimationTablet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTabletButton
implements IMessage {
    private BlockPos pos;
    private boolean rightClick;

    public PacketTabletButton() {
    }

    public PacketTabletButton(TileEntityAnimationTablet te, boolean rightClick) {
        this(te.func_174877_v(), rightClick);
    }

    public PacketTabletButton(BlockPos pos, boolean rightClick) {
        this.pos = pos;
        this.rightClick = rightClick;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isRightClick() {
        return this.rightClick;
    }

    public void setRightClick(boolean rightClick) {
        this.rightClick = rightClick;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.pos = BlockPos.func_177969_a((long)byteBuf.readLong());
        this.rightClick = byteBuf.readBoolean();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeLong(this.pos.func_177986_g());
        byteBuf.writeBoolean(this.rightClick);
    }

    public static class Handler
    implements IMessageHandler<PacketTabletButton, IMessage> {
        public IMessage onMessage(PacketTabletButton packetTabletButton, MessageContext messageContext) {
            FMLCommonHandler.instance().getWorldThread(messageContext.netHandler).func_152344_a(() -> this.handle(packetTabletButton, messageContext));
            return null;
        }

        private void handle(PacketTabletButton packetTabletButton, MessageContext messageContext) {
            TileEntity te;
            EntityPlayerMP playerEntity = messageContext.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            if (world.func_175667_e(packetTabletButton.getPos()) && (te = world.func_175625_s(packetTabletButton.getPos())) instanceof TileEntityAnimationTablet) {
                TileEntityAnimationTablet animationTablet = (TileEntityAnimationTablet)te;
                animationTablet.setRightClick(packetTabletButton.isRightClick());
            }
        }
    }
}

