/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.recipes;

import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.compat.botania.BotaniaCompat;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectTelekenesis;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.libs.LibRecipes;
import com.nekokittygames.thaumictinkerer.common.recipes.SpellClothRecipe;
import com.nekokittygames.thaumictinkerer.common.recipes.TTDustTriggerMultiblock;
import com.nekokittygames.thaumictinkerer.common.recipes.ing.TTFocusIngredient;
import com.nekokittygames.thaumictinkerer.common.recipes.ing.TTIngredientNBT;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.misc.BlockNitor;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class ModRecipes {
    private static final ResourceLocation defaultGroup = new ResourceLocation("");

    public static void initializeRecipes(IForgeRegistry<IRecipe> registry) {
        ModRecipes.registerOreDict();
        ModRecipes.initializeCraftingRecipes(registry);
        ModRecipes.initializeCauldronRecipes();
        ModRecipes.initializeArcaneRecipes();
        ModRecipes.initializeInfusionRecipes();
        ModRecipes.initializeMultiblockRecipes();
        BotaniaCompat.addOreDict();
    }

    private static void registerOreDict() {
        OreDictionary.registerOre((String)"blockQuartzDark", (Block)ModBlocks.black_quartz_block);
        OreDictionary.registerOre((String)"quartzDark", (Item)ModItems.black_quartz);
    }

    private static void initializeMultiblockRecipes() {
        Part AB = new Part((Object)BlocksTC.stoneArcaneBrick, (Object)BlocksTC.stoneArcaneBrick);
        Part BQ = new Part((Object)"blockQuartzDark", (Object)ModBlocks.black_quartz_block);
        Part DBQ = new Part((Object)ModBlocks.black_quartz_block, (Object)ModBlocks.black_quartz_block);
        Part[] pillars = new Part[16];
        for (int i = 0; i < 16; ++i) {
            pillars[i] = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.enchantment_pillar), 1, i));
        }
        Part NR = new Part(BlockNitor.class, (Object)"AIR");
        Part DN = new Part((Object)ModBlocks.dummy_nitor, (Object)"AIR");
        Part OE = new Part((Object)ModBlocks.osmotic_enchanter, (Object)ModBlocks.osmotic_enchanter);
        Part[][][] enchanterBP = new Part[][][]{{{null, null, null, NR, null, null, null}, {null, NR, null, null, null, NR, null}, {null, null, null, null, null, null, null}, {NR, null, null, null, null, null, NR}, {null, null, null, null, null, null, null}, {null, NR, null, null, null, NR, null}, {null, null, null, NR, null, null, null}}, {{null, null, null, pillars[15], null, null, null}, {null, pillars[14], null, null, null, pillars[8], null}, {null, null, null, null, null, null, null}, {pillars[13], null, null, null, null, null, pillars[9]}, {null, null, null, null, null, null, null}, {null, pillars[12], null, null, null, pillars[10], null}, {null, null, null, pillars[11], null, null, null}}, {{null, null, null, pillars[7], null, null, null}, {null, pillars[6], null, null, null, pillars[0], null}, {null, null, null, null, null, null, null}, {pillars[5], null, null, OE, null, null, pillars[1]}, {null, null, null, null, null, null, null}, {null, pillars[4], null, null, null, pillars[2], null}, {null, null, null, pillars[3], null, null, null}}, {{null, null, AB, AB, AB, null, null}, {null, AB, AB, BQ, AB, AB, null}, {AB, AB, BQ, BQ, BQ, AB, AB}, {AB, BQ, BQ, BQ, BQ, BQ, AB}, {AB, AB, BQ, BQ, BQ, AB, AB}, {null, AB, AB, BQ, AB, AB, null}, {null, null, AB, AB, AB, null, null}}};
        Part[][][] dummyenchanterBP = new Part[][][]{{{null, null, null, DN, null, null, null}, {null, DN, null, null, null, DN, null}, {null, null, null, null, null, null, null}, {DN, null, null, null, null, null, DN}, {null, null, null, null, null, null, null}, {null, DN, null, null, null, DN, null}, {null, null, null, DN, null, null, null}}, {{null, null, null, pillars[15], null, null, null}, {null, pillars[14], null, null, null, pillars[8], null}, {null, null, null, null, null, null, null}, {pillars[13], null, null, null, null, null, pillars[9]}, {null, null, null, null, null, null, null}, {null, pillars[12], null, null, null, pillars[10], null}, {null, null, null, pillars[11], null, null, null}}, {{null, null, null, pillars[7], null, null, null}, {null, pillars[6], null, null, null, pillars[0], null}, {null, null, null, null, null, null, null}, {pillars[5], null, null, OE, null, null, pillars[1]}, {null, null, null, null, null, null, null}, {null, pillars[4], null, null, null, pillars[2], null}, {null, null, null, pillars[3], null, null, null}}, {{null, null, AB, AB, AB, null, null}, {null, AB, AB, DBQ, AB, AB, null}, {AB, AB, DBQ, DBQ, DBQ, AB, AB}, {AB, DBQ, DBQ, DBQ, DBQ, DBQ, AB}, {AB, AB, DBQ, DBQ, DBQ, AB, AB}, {null, AB, AB, DBQ, AB, AB, null}, {null, null, AB, AB, AB, null, null}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new TTDustTriggerMultiblock("TT_ENCHANTER", enchanterBP));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)LibRecipes.OSMOTIC_ENCHANTER_MB, (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("TT_ENCHANTER", (Part[][][])dummyenchanterBP, new ItemStack[]{new ItemStack((Block)Objects.requireNonNull(ModBlocks.black_quartz_block), 13), new ItemStack(BlocksTC.stoneArcaneBrick, 24), new ItemStack(BlocksTC.stoneArcane, 16), new ItemStack((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW), 8)}));
    }

    private static void initializeCauldronRecipes() {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.PRISMARINE, (CrucibleRecipe)new CrucibleRecipe("TT_PRISMARINE", new ItemStack(Items.field_179562_cC), (Object)"paneGlass", new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.SOUL_MOLD, (CrucibleRecipe)new CrucibleRecipe("TT_THAUMIC_MAGNETS", new ItemStack((Item)Objects.requireNonNull(ModItems.soul_mould)), (Object)new ItemStack(Items.field_151079_bi), new AspectList().add(Aspect.BEAST, 5).add(Aspect.MIND, 10).add(Aspect.SENSES, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.SPELLBINDING_CLOTH, (CrucibleRecipe)new CrucibleRecipe("TT_SPELLBINDING_CLOTH", new ItemStack((Item)Objects.requireNonNull(ModItems.spellbinding_cloth)), (Object)new ItemStack(ItemsTC.fabric), new AspectList().add(Aspect.EXCHANGE, 4).add(Aspect.ENTROPY, 6).add(Aspect.MAGIC, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.ENERGETIC_NITOR, (CrucibleRecipe)new CrucibleRecipe("TT_ENERGETIC_NITOR", new ItemStack((Item)Objects.requireNonNull(ModItems.energetic_nitor)), (Object)"nitor", new AspectList().add(Aspect.FIRE, 10).add(Aspect.AIR, 10).add(Aspect.LIGHT, 25).add(Aspect.ENERGY, 25)));
    }

    private static void initializeCraftingRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register((IForgeRegistryEntry)new SpellClothRecipe(ModItems.spellbinding_cloth));
    }

    private static void initializeArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.FUNNEL, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ESSENTIA_FUNNEL", 60, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.funnel)), new Object[]{"STS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('T'), "ingotThaumium"}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.DISSIMULATION, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_DISSIMULATION", 30, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.dissimulation)), new Object[]{"BEB", "PBP", "BEB", Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('E'), new ItemStack(Items.field_151119_aD), Character.valueOf('P'), new ItemStack(Items.field_179562_cC)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TRANSVECTOR_INTERFACE, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TRANSVECTOR_INTERFACE@2", 200, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.transvector_interface)), new Object[]{"BRB", "LEL", "BDB", Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('D'), new ItemStack((Block)Objects.requireNonNull(ModBlocks.dissimulation))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TRANSVECTOR_DISLOCATOR, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TRANSVECTOR_INTERFACE", 200, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5), new ItemStack((Block)Objects.requireNonNull(ModBlocks.transvector_dislocator)), new Object[]{" M ", " T ", " C ", Character.valueOf('M'), new ItemStack(ItemsTC.mirroredGlass), Character.valueOf('T'), new ItemStack((Block)ModBlocks.transvector_interface), Character.valueOf('C'), new ItemStack(Items.field_151132_bS)}));
        ItemStack airCrystal = new ItemStack(ItemsTC.crystalEssence);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(airCrystal, new AspectList().add(Aspect.AIR, 1));
        ItemStack earthCrystal = new ItemStack(ItemsTC.crystalEssence);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(earthCrystal, new AspectList().add(Aspect.EARTH, 1));
        ItemStack focus = new ItemStack(ItemsTC.focus1);
        FocusPackage focusPackage = new FocusPackage();
        focusPackage.addNode((IFocusElement)new FocusEffectTelekenesis());
        ItemFocus.setPackage((ItemStack)focus, (FocusPackage)focusPackage);
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.MOB_MAGNET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_THAUMIC_MAGNETS", 200, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.mob_magnet)), new Object[]{" C ", "ACE", "GFG", Character.valueOf('C'), new ItemStack(ItemsTC.ingots, 1, 0), Character.valueOf('A'), new TTIngredientNBT(airCrystal), Character.valueOf('E'), new TTIngredientNBT(earthCrystal), Character.valueOf('G'), new ItemStack(BlocksTC.logGreatwood), Character.valueOf('F'), new TTFocusIngredient(FocusEffectTelekenesis.class, focus)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.ITEM_MAGNET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_THAUMIC_MAGNETS@1", 20, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.magnet)), new Object[]{" C ", "ACE", "GFG", Character.valueOf('C'), "ingotIron", Character.valueOf('A'), new TTIngredientNBT(airCrystal), Character.valueOf('E'), new TTIngredientNBT(earthCrystal), Character.valueOf('G'), new ItemStack(BlocksTC.logGreatwood), Character.valueOf('F'), new TTFocusIngredient(FocusEffectTelekenesis.class, focus)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TABLET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TABLET", 20, new AspectList().add(Aspect.AIR, 3).add(Aspect.ORDER, 2).add(Aspect.FIRE, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.animation_tablet)), new Object[]{"GIG", "ISI", Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('S'), new ItemStack(ItemsTC.seals)}));
    }

    private static void initializeInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.ENCHANTER, (InfusionRecipe)new InfusionRecipe("TT_ENCHANTER", (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.osmotic_enchanter)), 1, new AspectList().add(Aspect.ELDRITCH, 20).add(Aspect.MIND, 10).add(Aspect.ENERGY, 20).add(Aspect.MAGIC, 50).add(Aspect.VOID, 20), (Object)new ItemStack(Blocks.field_150381_bn), new Object[]{new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack((Item)Objects.requireNonNull(ModItems.spellbinding_cloth)), new ItemStack(ItemsTC.ingots, 1, 0), new ItemStack(ItemsTC.ingots, 1, 0)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.REPAIRER, (InfusionRecipe)new InfusionRecipe("TT_REPAIRER", (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.repairer)), 1, new AspectList().add(Aspect.CRAFT, 20).add(Aspect.TOOL, 15).add(Aspect.ORDER, 10).add(Aspect.MAGIC, 15), (Object)new ItemStack(BlocksTC.metalBlockThaumium), new Object[]{"plankWood", new ItemStack(Items.field_151116_aA), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.ingots, 1, 0), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150347_e)}));
    }
}

