/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.helper.OreDictHelper;
import com.nekokittygames.thaumictinkerer.common.helper.Tuple4Int;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockManager;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.resources.ItemCrystalEssence;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class TileEntityEnchanter
extends TileEntityThaumicTinkerer
implements ITickable,
IInventory {
    private static final ResourceLocation MULTIBLOCK_LOCATION = new ResourceLocation("thaumictinkerer", "osmotic_enchanter");
    private static final String TAG_ENCHANTS = "enchantsIntArray";
    private static final String TAG_LEVELS = "levelsIntArray";
    private static final String TAG_CACHED_ENCHANTS = "cachedEnchants";
    private static final String TAG_WORKING = "working";
    private static final String TAG_PROGRESS = "progress";
    private static final String TAG_AURA = "aura";
    private List<Integer> enchantments = new ArrayList<Integer>();
    private List<Integer> levels = new ArrayList<Integer>();
    private List<Integer> cachedEnchantments = new ArrayList<Integer>();
    private int progress;
    private int cooldown;
    private int auraVisServer = 0;
    private boolean working = false;
    private List<Tuple4Int> pillars = new ArrayList<Tuple4Int>();
    private Vec3d[] points = new Vec3d[]{new Vec3d(-1.2, 2.15, -1.2), new Vec3d(-2.2, 2.15, 0.5), new Vec3d(-1.2, 2.15, 2.2), new Vec3d(0.5, 2.15, 3.2), new Vec3d(2.2, 2.15, 2.2), new Vec3d(3.2, 2.15, 0.5), new Vec3d(2.2, 2.15, -1.2), new Vec3d(0.5, 2.15, -2.2)};
    private Color c;
    private ItemStackHandler inventory;

    public TileEntityEnchanter() {
        this.c = new Color(MapColor.field_151647_F.field_76291_p);
        this.inventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityEnchanter.this.onInventoryChanged(this.getStackInSlot(slot));
                TileEntityEnchanter.this.sendUpdates();
            }

            boolean isItemValidForSlot(int index, ItemStack stack) {
                return TileEntityEnchanter.this.func_94041_b(index, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private static boolean canApply(ItemStack itemStack, Enchantment enchantment, List<Enchantment> currentEnchants) {
        return TileEntityEnchanter.canApply(itemStack, enchantment, currentEnchants, true);
    }

    private static boolean canApply(ItemStack itemStack, Enchantment enchantment, List<Enchantment> currentEnchants, boolean checkConflicts) {
        if (ArrayUtils.contains((int[])TTConfig.blacklistedEnchants, (int)Enchantment.func_185258_b((Enchantment)enchantment))) {
            return false;
        }
        if (!enchantment.func_92089_a(itemStack) || !Objects.requireNonNull(enchantment.field_77351_y).func_77557_a(itemStack.func_77973_b()) || currentEnchants.contains(enchantment)) {
            return false;
        }
        if (EnchantmentHelper.func_82781_a((ItemStack)itemStack).keySet().contains(enchantment)) {
            return false;
        }
        if (checkConflicts) {
            for (Enchantment curEnchant : currentEnchants) {
                if (curEnchant.func_191560_c(enchantment)) continue;
                return false;
            }
        }
        return true;
    }

    public List<Integer> getEnchantments() {
        return this.enchantments;
    }

    public List<Integer> getLevels() {
        return this.levels;
    }

    public List<Integer> getCachedEnchantments() {
        return this.cachedEnchantments;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
        this.sendUpdates();
    }

    public List<Tuple4Int> getPillars() {
        return this.pillars;
    }

    public void clearEnchants() {
        this.enchantments.clear();
        this.levels.clear();
    }

    public void appendEnchant(int enchant) {
        this.enchantments.add(enchant);
        this.refreshEnchants();
        this.sendUpdates();
    }

    public void appendLevel(int level) {
        this.levels.add(level);
    }

    public void removeEnchant(int index) {
        this.enchantments.remove(index);
        this.refreshEnchants();
    }

    public void removeLevel(int index) {
        this.levels.remove(index);
    }

    public void setEnchant(int index, int enchant) {
        this.enchantments.set(index, enchant);
    }

    public void setLevel(int index, int level) {
        this.levels.set(index, level);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    private void onInventoryChanged(ItemStack stackInSlot) {
        this.refreshEnchants();
    }

    public void BreakPillars() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(3)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(3), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(3).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(3).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177965_g(3)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177965_g(3), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177965_g(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177965_g(3).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177965_g(3).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(3)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(3), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(3).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(3).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177985_f(3)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177985_f(3), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177985_f(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177985_f(3).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177985_f(3).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177965_g(2)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177965_g(2), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177965_g(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177965_g(2).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177965_g(2).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177965_g(2)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177965_g(2), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177965_g(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177965_g(2).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177965_g(2).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177985_f(2)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177985_f(2), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177985_f(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177985_f(2).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177964_d(2).func_177985_f(2).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177985_f(2)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177985_f(2), BlocksTC.stoneArcane.func_176223_P());
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177985_f(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177985_f(2).func_177981_b(1), BlocksTC.stoneArcane.func_176223_P());
        }
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177970_e(2).func_177985_f(2).func_177981_b(2), ((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)).func_176223_P());
    }

    public boolean checkLocation() {
        boolean valid = this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(3)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177965_g(3)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(3)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177985_f(3)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177965_g(2)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177965_g(2)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177985_f(2)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177985_f(2)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177965_g(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177985_f(3).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177965_g(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177965_g(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177970_e(2).func_177985_f(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177964_d(2).func_177985_f(2).func_177981_b(1)).func_177230_c() == ModBlocks.enchantment_pillar;
        int oreDictNum = OreDictionary.getOreID((String)"blockQuartzDark");
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(2)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(2)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177965_g(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177965_g(2)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177985_f(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177985_f(2)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177965_g(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177985_f(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177965_g(1)), oreDictNum);
        valid = valid && OreDictHelper.oreDictCheck(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177985_f(1)), oreDictNum);
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(3).func_177965_g(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(3).func_177985_f(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(2).func_177965_g(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(2).func_177965_g(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(2).func_177985_f(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(2).func_177985_f(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177965_g(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177965_g(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177985_f(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177964_d(1).func_177985_f(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177965_g(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177985_f(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(3).func_177965_g(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(3).func_177985_f(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(2).func_177965_g(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(2).func_177965_g(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(2).func_177985_f(1)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(2).func_177985_f(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177965_g(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177965_g(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177985_f(2)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        valid = valid && this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1).func_177970_e(1).func_177985_f(3)).func_177230_c() == BlocksTC.stoneArcaneBrick;
        return valid;
    }

    public void refreshEnchants() {
        List<Enchantment> enchantmentObjects = this.getAvailableEnchants(this.enchantments.stream().map(Enchantment::func_185262_c).collect(Collectors.toList()));
        this.cachedEnchantments = enchantmentObjects.stream().map(Enchantment::func_185258_b).collect(Collectors.toList());
        this.getAura();
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.inventory.getStackInSlot(0) == ItemStack.field_190927_a;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(Arrays.asList(this.inventory.getStackInSlot(0)), (int)index, (int)count);
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = ItemStackHelper.func_188383_a(Arrays.asList(this.inventory.getStackInSlot(0)), (int)index);
        return itemStack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_77616_k(stack) && !stack.func_77948_v();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbttagcompound.func_74783_a(TAG_ENCHANTS, this.enchantments.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74783_a(TAG_LEVELS, this.levels.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74783_a(TAG_CACHED_ENCHANTS, this.cachedEnchantments.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74768_a(TAG_PROGRESS, this.progress);
        nbttagcompound.func_74757_a(TAG_WORKING, this.working);
        nbttagcompound.func_74768_a(TAG_AURA, this.auraVisServer);
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
        if (nbttagcompound.func_74764_b(TAG_ENCHANTS)) {
            this.enchantments.clear();
            this.levels.clear();
            this.cachedEnchantments.clear();
            int[] enchantmentArray = nbttagcompound.func_74759_k(TAG_ENCHANTS);
            Arrays.stream(enchantmentArray).forEach(i -> this.enchantments.add(i));
            int[] levelsArray = nbttagcompound.func_74759_k(TAG_LEVELS);
            Arrays.stream(levelsArray).forEach(i -> this.levels.add(i));
            int[] cachedEnchantmentArray = nbttagcompound.func_74759_k(TAG_CACHED_ENCHANTS);
            Arrays.stream(cachedEnchantmentArray).forEach(i -> this.cachedEnchantments.add(i));
        }
        if (nbttagcompound.func_74764_b(TAG_PROGRESS)) {
            this.progress = nbttagcompound.func_74762_e(TAG_PROGRESS);
        }
        if (nbttagcompound.func_74764_b(TAG_WORKING)) {
            this.working = nbttagcompound.func_74767_n(TAG_WORKING);
        }
        if (nbttagcompound.func_74764_b(TAG_AURA)) {
            this.auraVisServer = nbttagcompound.func_74762_e(TAG_AURA);
        }
    }

    @Override
    public boolean respondsToPulses() {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            this.clearEnchants();
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.working) {
            ItemStack tool = this.inventory.getStackInSlot(0);
            if (tool == ItemStack.field_190927_a) {
                this.working = false;
                this.progress = 0;
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundsTC.craftfail, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                return;
            }
            this.checkStructure();
            if (!this.working) {
                this.progress = 0;
                return;
            }
            ++this.progress;
            float percenDone = (float)this.progress / 300.0f * 100.0f / 75.0f * 100.0f;
            if (this.field_145850_b.field_72995_K && !TTConfig.ClassicEnchanter) {
                this.newEnchant(percenDone);
            }
            if (!TTConfig.ClassicEnchanter) {
                this.playCorrectSound(percenDone);
            }
            if (this.progress > 300) {
                if (!this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < this.enchantments.size(); ++i) {
                        tool.func_77966_a(Objects.requireNonNull(Enchantment.func_185262_c((int)this.enchantments.get(i))), this.levels.get(i).intValue());
                    }
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundsTC.wand, SoundCategory.BLOCKS, 0.5f, 1.0f, false);
                this.progress = 0;
                this.working = false;
                this.cooldown = 28;
                this.spendAura(this.getEnchantmentVisCost());
                this.getAura();
                this.clearEnchants();
                this.sendUpdates();
            }
        }
    }

    private void playCorrectSound(float percentDone) {
        Vec3d targetPos;
        Vec3d curPos = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        if (percentDone >= 0.0f && percentDone <= 0.5f) {
            targetPos = curPos.func_178787_e(this.points[0]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 12.4f && percentDone <= 12.7f) {
            targetPos = curPos.func_178787_e(this.points[1]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 24.7f && percentDone <= 25.4f) {
            targetPos = curPos.func_178787_e(this.points[2]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 37.3f && percentDone <= 37.6f) {
            targetPos = curPos.func_178787_e(this.points[3]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 49.7f && percentDone <= 50.1f) {
            targetPos = curPos.func_178787_e(this.points[4]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 61.3f && percentDone <= 61.7f) {
            targetPos = curPos.func_178787_e(this.points[5]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 74.6f && percentDone <= 75.1f) {
            targetPos = curPos.func_178787_e(this.points[6]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 87.5f && percentDone <= 88.0f) {
            targetPos = curPos.func_178787_e(this.points[7]);
            this.field_145850_b.func_184134_a(targetPos.field_72450_a + 0.5, targetPos.field_72448_b + 0.5, targetPos.field_72449_c + 0.5, SoundsTC.jacobs, SoundCategory.BLOCKS, 0.5f, 1.0f, true);
        }
        if (percentDone >= 99.6f && percentDone <= 100.3f) {
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundsTC.brain, SoundCategory.BLOCKS, 0.25f, 1.0f, false);
        }
    }

    private void newEnchant(float percenDone) {
        if (percenDone >= 0.0f) {
            this.arcPoints(0, 1);
        }
        if ((double)percenDone >= 12.5) {
            this.arcPoints(1, 2);
        }
        if (percenDone >= 25.0f) {
            this.arcPoints(2, 3);
        }
        if ((double)percenDone >= 37.5) {
            this.arcPoints(3, 4);
        }
        if (percenDone >= 50.0f) {
            this.arcPoints(4, 5);
        }
        if ((double)percenDone >= 62.5) {
            this.arcPoints(5, 6);
        }
        if (percenDone >= 75.0f) {
            this.arcPoints(6, 7);
        }
        if ((double)percenDone >= 87.5) {
            this.arcPoints(7, 0);
        }
        if (percenDone >= 100.0f) {
            for (Vec3d point : this.points) {
                Vec3d curPos = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                Vec3d originPos = curPos.func_178787_e(point);
                FXDispatcher.INSTANCE.arcLightning(originPos.field_72450_a, originPos.field_72448_b, originPos.field_72449_c, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177984_a().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), (float)this.c.getRed() / 255.0f, (float)this.c.getGreen() / 255.0f, (float)this.c.getBlue() / 255.0f, 0.5f);
            }
        }
    }

    public boolean playerHasIngredients(List<ItemStack> stacks, EntityPlayer player) {
        for (ItemStack stack : stacks) {
            if (InventoryUtils.isPlayerCarryingAmount((EntityPlayer)player, (ItemStack)stack, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    public void takeIngredients(List<ItemStack> stacks, EntityPlayer player) {
        for (ItemStack stack : stacks) {
            InventoryUtils.consumePlayerItem((EntityPlayer)player, (ItemStack)stack, (boolean)true, (boolean)false);
        }
    }

    private void arcPoints(int start, int end) {
        Vec3d curPos = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        Vec3d originPos = curPos.func_178787_e(this.points[start]);
        Vec3d nextPos = curPos.func_178787_e(this.points[end]);
        FXDispatcher.INSTANCE.arcLightning(originPos.field_72450_a, originPos.field_72448_b, originPos.field_72449_c, nextPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c, (float)this.c.getRed() / 255.0f, (float)this.c.getGreen() / 255.0f, (float)this.c.getBlue() / 255.0f, 1.0f);
    }

    private void checkStructure() {
        if (TTConfig.ClassicEnchanter) {
            this.checkPillars();
        } else if (!MultiblockManager.checkMultiblockCombined(this.field_145850_b, this.func_174877_v(), MULTIBLOCK_LOCATION)) {
            this.working = false;
        }
    }

    private boolean checkPillars() {
        if (this.pillars.isEmpty()) {
            if (this.assignPillars()) {
                this.working = false;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.pillars.size(); ++i) {
            Tuple4Int pillar = this.pillars.get(i);
            int pillarHeight = this.findPillar(new BlockPos(pillar.i1, pillar.i2, pillar.i3));
            if (pillarHeight == -1) {
                this.pillars.clear();
                return this.checkPillars();
            }
            if (pillarHeight == pillar.i4) continue;
            pillar.i4 = pillarHeight;
        }
        return true;
    }

    private boolean assignPillars() {
        int y = this.field_174879_c.func_177956_o();
        for (int x = this.field_174879_c.func_177958_n() - 4; x <= this.field_174879_c.func_177958_n() + 4; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 4; z <= this.field_174879_c.func_177952_p() + 4; ++z) {
                int height = this.findPillar(new BlockPos(x, y, z));
                if (height != -1) {
                    this.pillars.add(new Tuple4Int(x, y, z, height));
                }
                if (this.pillars.size() != 6) continue;
                return false;
            }
        }
        this.pillars.clear();
        return true;
    }

    private int findPillar(BlockPos pillarPos) {
        int obsidianFound = 0;
        int i = 0;
        while (pillarPos.func_177956_o() + i < 256) {
            IBlockState id = this.field_145850_b.func_180495_p(pillarPos.func_177981_b(i));
            if (id.func_177230_c() == Blocks.field_150343_Z) {
                ++obsidianFound;
            } else {
                if (BlocksTC.nitor.containsValue(id.func_177230_c())) {
                    if (obsidianFound >= 2 && obsidianFound < 13) {
                        return pillarPos.func_177956_o() + i;
                    }
                    return -1;
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    private List<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            return enchantments;
        }
        ItemStack item = this.inventory.getStackInSlot(0);
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            if (item.func_77973_b().getItemEnchantability(item) == 0 || !TileEntityEnchanter.canApply(item, enchantment, enchantments, false)) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    private List<Enchantment> getAvailableEnchants(List<Enchantment> currentEnchants) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            return enchantments;
        }
        ItemStack item = this.inventory.getStackInSlot(0);
        List<Enchantment> valid = this.getValidEnchantments();
        for (Enchantment validEnchant : valid) {
            if (item.func_77973_b().getItemEnchantability(item) == 0 || !TileEntityEnchanter.canApply(item, validEnchant, enchantments, false) || !TileEntityEnchanter.canApply(item, validEnchant, currentEnchants)) continue;
            enchantments.add(validEnchant);
        }
        return enchantments;
    }

    public int getEnchantmentVisCost() {
        List enchantmentObjects = this.enchantments.stream().map(Enchantment::func_185262_c).collect(Collectors.toList());
        int visAmount = 0;
        int enchantmentObjectsSize = enchantmentObjects.size();
        block6: for (int i = 0; i < enchantmentObjectsSize; ++i) {
            Enchantment enchantment = (Enchantment)enchantmentObjects.get(i);
            switch (enchantment.func_77324_c()) {
                case COMMON: {
                    visAmount += 25 * this.getLevels().get(i);
                    continue block6;
                }
                case UNCOMMON: {
                    visAmount += 35 * this.getLevels().get(i);
                    continue block6;
                }
                case RARE: {
                    visAmount += 40 * this.getLevels().get(i);
                    continue block6;
                }
                case VERY_RARE: {
                    visAmount += 50 * this.getLevels().get(i);
                }
            }
        }
        return visAmount;
    }

    public List<ItemStack> getEnchantmentCost() {
        ArrayList<ItemStack> costs = new ArrayList<ItemStack>();
        HashMap<Aspect, Integer> costItems = new HashMap<Aspect, Integer>();
        List enchantmentObjects = this.enchantments.stream().map(Enchantment::func_185262_c).collect(Collectors.toList());
        int visAmount = 0;
        int enchantmentObjectsSize = enchantmentObjects.size();
        block18: for (int i = 0; i < enchantmentObjectsSize; ++i) {
            Enchantment enchantment = (Enchantment)enchantmentObjects.get(i);
            switch (enchantment.func_77324_c()) {
                case COMMON: {
                    visAmount += 25 * this.getLevels().get(i);
                    break;
                }
                case UNCOMMON: {
                    visAmount += 35 * this.getLevels().get(i);
                    break;
                }
                case RARE: {
                    visAmount += 40 * this.getLevels().get(i);
                    break;
                }
                case VERY_RARE: {
                    visAmount += 50 * this.getLevels().get(i);
                }
            }
            switch (Objects.requireNonNull(enchantment.field_77351_y)) {
                case ARMOR: 
                case ARMOR_LEGS: {
                    this.addAmountTo(costItems, Aspect.PROTECT, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case ARMOR_FEET: {
                    this.addAmountTo(costItems, Aspect.PROTECT, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.MOTION, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case ARMOR_CHEST: {
                    this.addAmountTo(costItems, Aspect.PROTECT, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.LIFE, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case ARMOR_HEAD: {
                    this.addAmountTo(costItems, Aspect.PROTECT, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.MIND, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case DIGGER: {
                    this.addAmountTo(costItems, Aspect.ENTROPY, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.TOOL, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case BREAKABLE: {
                    this.addAmountTo(costItems, Aspect.ENTROPY, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case WEARABLE: {
                    this.addAmountTo(costItems, Aspect.MAN, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case WEAPON: {
                    this.addAmountTo(costItems, Aspect.DEATH, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.AVERSION, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case BOW: {
                    this.addAmountTo(costItems, Aspect.DEATH, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
                case FISHING_ROD: {
                    this.addAmountTo(costItems, Aspect.BEAST, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    this.addAmountTo(costItems, Aspect.WATER, (int)Math.pow(2.0, this.getLevels().get(i).intValue()));
                    continue block18;
                }
            }
        }
        for (Aspect item : costItems.keySet()) {
            ItemStack crystal = new ItemStack(ItemsTC.crystalEssence, ((Integer)costItems.get(item)).intValue());
            ((ItemCrystalEssence)crystal.func_77973_b()).setAspects(crystal, new AspectList().add(item, 1));
            costs.add(crystal);
        }
        return costs;
    }

    private void addAmountTo(Map<Aspect, Integer> costItems, Aspect crystalEssence, int amount) {
        if (costItems.containsKey(crystalEssence)) {
            costItems.put(crystalEssence, costItems.get(crystalEssence) + amount);
        } else {
            costItems.put(crystalEssence, amount);
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void getAura() {
        if (!this.func_145831_w().field_72995_K) {
            int t = 0;
            int sx = this.field_174879_c.func_177958_n() >> 4;
            int sz = this.field_174879_c.func_177952_p() >> 4;
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    AuraChunk ac = AuraHandler.getAuraChunk((int)this.field_145850_b.field_73011_w.getDimension(), (int)(sx + xx), (int)(sz + zz));
                    if (ac == null) continue;
                    t = (int)((float)t + ac.getVis());
                }
            }
            this.auraVisServer = t;
        }
    }

    public void spendAura(int vis) {
        if (!this.func_145831_w().field_72995_K) {
            int q = vis;
            int z = Math.max(1, vis / 9);
            int attempts = 0;
            while (q > 0) {
                ++attempts;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        if (z > q) {
                            z = q;
                        }
                        if ((q = (int)((float)q - AuraHandler.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177982_a(xx * 16, 0, zz * 16), (float)z, (boolean)false))) > 0 && attempts <= 1000) continue;
                        return;
                    }
                }
            }
        }
    }

    public int getAuraVisServer() {
        return this.auraVisServer;
    }

    public void setAuraVisServer(int auraVisServer) {
        this.auraVisServer = auraVisServer;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }
}

