/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.items.ItemSoulMould;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityMagnet;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMobMagnet
extends TileEntityMagnet {
    private boolean pullAdults = true;

    public boolean isPullAdults() {
        return this.pullAdults;
    }

    public void setPullAdults(boolean pullAdults) {
        this.pullAdults = pullAdults;
        this.sendUpdates();
    }

    @Override
    protected boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemSoulMould;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        super.writeExtraNBT(nbttagcompound);
        nbttagcompound.func_74757_a("adults", this.pullAdults);
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        super.readExtraNBT(nbttagcompound);
        this.pullAdults = nbttagcompound.func_74767_n("adults");
    }

    @Override
    public boolean respondsToPulses() {
        return false;
    }

    @Override
    protected <T extends Entity> Predicate selectedEntities() {
        return o -> o instanceof EntityLiving && this.filterEntity((Entity)o);
    }

    @Override
    protected boolean filterEntity(Entity entity) {
        EntityLiving entityLiving = (EntityLiving)entity;
        boolean agePull = false;
        agePull = entityLiving instanceof EntityAgeable ? this.isPullAdults() != ((EntityAgeable)entity).func_70631_g_() : true;
        boolean typePull = true;
        if (this.getInventory().getStackInSlot(0) != ItemStack.field_190927_a) {
            String selectedEntity = ItemSoulMould.getEntityName(this.getInventory().getStackInSlot(0));
            String targetEntity = EntityList.func_75621_b((Entity)entity);
            if (selectedEntity != null && !selectedEntity.equalsIgnoreCase(targetEntity)) {
                typePull = false;
            }
        }
        return agePull && typePull;
    }
}

