/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.unstabletools.item;

import com.tfar.unstabletools.crafting.IDivisionItem;
import com.tfar.unstabletools.item.IItemColored;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemDivisionSign
extends Item
implements IDivisionItem,
IItemColored {
    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && (stack.func_77978_p().func_74767_n("activated") || stack.func_77978_p().func_74767_n("activated"));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("activated", false);
            stack.func_77982_d(nbt);
        }
    }

    @Nonnull
    public ItemStack getContainerItem(ItemStack itemStack) {
        return ItemDivisionSign.damage(itemStack.func_77946_l());
    }

    public static ItemStack damage(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        boolean stable = stack.func_77978_p().func_74767_n("stable");
        if (stable) {
            return stack;
        }
        int d = nbt.func_74762_e("d");
        nbt.func_74768_a("d", --d);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean skyVisible;
        if (hand == EnumHand.OFF_HAND || world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != Blocks.field_150381_bn) {
            return EnumActionResult.FAIL;
        }
        long time = world.func_72912_H().func_76073_f() % 24000L;
        boolean correctTime = false;
        if (time <= 17500L) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.early", new Object[0]));
        } else if (time <= 18500L) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.ontime", new Object[0]));
            correctTime = true;
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.late", new Object[0]));
        }
        boolean circle = true;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1;
                if (i == 0 && j == 0 || world.func_180495_p(pos1 = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p() + j)).func_177230_c() == Blocks.field_150488_af) continue;
                circle = false;
            }
        }
        if (!circle) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.incomplete", new Object[0]));
        }
        if (!(skyVisible = world.func_175678_i(pos.func_177984_a()))) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.nosky", new Object[0]));
        }
        if (correctTime && circle && skyVisible) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("unstabletools.ready", new Object[0]));
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            return;
        }
        boolean stable = stack.func_77978_p().func_74767_n("stable");
        if (stable) {
            tooltip.add("Stable");
            return;
        }
        boolean activated = stack.func_77978_p().func_74767_n("activated");
        tooltip.add("Activated: " + activated);
        if (!activated) {
            return;
        }
        tooltip.add("Uses Left: " + stack.func_77978_p().func_74762_e("d"));
    }

    @SubscribeEvent
    public static void onSacrifice(LivingDeathEvent e) {
        EntityLivingBase sacrifice;
        if (!(e.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e.getSource().func_76346_g();
        World world = sacrifice.field_70170_p;
        sacrifice = e.getEntityLiving();
        BlockPos pos = sacrifice.func_180425_c();
        if (!world.func_175678_i(pos)) {
            return;
        }
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (block != Blocks.field_150381_bn) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1;
                if (i == 0 && j == 0 || world.func_180495_p(pos1 = new BlockPos(pos.func_177977_b().func_177958_n() + i, pos.func_177977_b().func_177956_o(), pos.func_177977_b().func_177952_p() + j)).func_177230_c() == Blocks.field_150488_af) continue;
                return;
            }
        }
        long time = world.func_72912_H().func_76073_f() % 24000L;
        if (time <= 17500L || time > 18500L) {
            return;
        }
        for (Slot slot : player.field_71069_bz.field_75151_b) {
            ItemStack stack = slot.func_75211_c();
            if (!(stack.func_77973_b() instanceof IDivisionItem)) continue;
            stack.func_77978_p().func_74757_a("activated", true);
            stack.func_77978_p().func_74768_a("d", 256);
        }
        sacrifice.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(sacrifice.field_70170_p, sacrifice.field_70165_t, sacrifice.field_70163_u, sacrifice.field_70161_v, false));
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        return !stack.func_77942_o() ? 0xEE0000 : (stack.func_77978_p().func_74767_n("stable") ? 0x50DD00 : 0xEE0000);
    }
}

