/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.unstabletools.item;

import com.tfar.unstabletools.ObjectHolders;
import com.tfar.unstabletools.UnstableToolsConfig;
import com.tfar.unstabletools.item.IItemColored;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemUnstableIngot
extends Item
implements IItemColored {
    public static final DamageSource DIVIDE_BY_DIAMOND = new DamageSource("divide_by_diamond");
    public static final DamageSource ESCAPE_DIVIDE_BY_DIAMOND = new DamageSource("escape_divide_by_diamond");

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            tooltip.add("'Stable'");
            return;
        }
        int timer = stack.func_77978_p().func_74762_e("timer");
        tooltip.add("Time left: " + timer);
    }

    @SubscribeEvent
    public static void playertick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        World world = e.player.field_70170_p;
        Container container = e.player.field_71070_bA;
        if (UnstableToolsConfig.allowed_container_classes.contains(container.getClass())) {
            boolean explode = false;
            for (Slot slot : container.field_75151_b) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_77973_b() != ObjectHolders.unstableIngot || !stack.func_77942_o() || slot instanceof SlotCrafting) continue;
                int timer = stack.func_77978_p().func_74762_e("timer");
                if (timer == 0) {
                    stack.func_190918_g(1);
                    explode = true;
                    continue;
                }
                stack.func_77978_p().func_74768_a("timer", --timer);
            }
            if (!world.field_72995_K) {
                container.func_75142_b();
            }
            if (!explode) {
                return;
            }
            EntityPlayer p = e.player;
            world.func_72876_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, 1.0f, false);
            p.func_70097_a(DIVIDE_BY_DIAMOND, 100.0f);
        }
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close e) {
        EntityPlayer p = e.getEntityPlayer();
        Container c = e.getContainer();
        boolean explode = false;
        for (Slot slot : c.field_75151_b) {
            ItemStack stack = slot.func_75211_c();
            if (!ItemUnstableIngot.checkExplosion(stack) || slot instanceof SlotCrafting) continue;
            stack.func_190918_g(1);
            explode = true;
        }
        if (!explode) {
            return;
        }
        p.field_70170_p.func_72876_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, 1.0f, false);
        p.func_70097_a(ESCAPE_DIVIDE_BY_DIAMOND, 100.0f);
    }

    @SubscribeEvent
    public static void onItemDrop(ItemTossEvent e) {
        EntityPlayer p = e.getPlayer();
        EntityItem entityItem = e.getEntityItem();
        ItemStack stack = entityItem.func_92059_d();
        if (ItemUnstableIngot.checkExplosion(stack)) {
            p.field_70170_p.func_72876_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, 1.0f, false);
            p.func_70097_a(ESCAPE_DIVIDE_BY_DIAMOND, 100.0f);
            e.setCanceled(true);
        }
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        int blue;
        int red;
        int green;
        if (!stack.func_77942_o()) {
            return 0xFFFFFF;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int color = nbt.func_74762_e("timer");
        double scale = (double)color / 200.0;
        if (scale >= 0.5) {
            green = 255;
            red = 255;
            blue = (int)((2.0 * scale - 1.0) * 255.0);
        } else if (scale >= 0.25) {
            red = 255;
            green = (int)(2.0 * scale * 255.0);
            blue = 0;
        } else {
            scale *= 256.0;
            scale = Math.floor(scale);
            switch ((int)(scale %= 2.0)) {
                case 0: {
                    red = 255;
                    blue = 0;
                    green = 0;
                    break;
                }
                case 1: {
                    green = 255;
                    red = 255;
                    blue = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return (red << 16) + (green << 8) + blue;
    }

    public static boolean checkExplosion(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77973_b() == ObjectHolders.unstableIngot && stack.func_77978_p().func_74762_e("timer") > 0;
    }
}

