/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.core;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.embeddedt.vintagefix.jarcache.JarDiscovererCache;
import org.embeddedt.vintagefix.util.DummyList;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import zone.rong.mixinbooter.IEarlyMixinLoader;

@IFMLLoadingPlugin.Name(value="VintageFix")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class VintageFixCore
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static boolean OPTIFINE;
    public static boolean VINTAGIUM;
    public static boolean SPONGE;
    private static final int MAXIMUM_RESOURCE_CACHE_SIZE = 0x1400000;
    private static boolean mixinFixApplied;

    public VintageFixCore() {
        for (String clz : new String[]{"zone.rong.loliasm.core.LoliTransformer", "mirror.normalasm.core.NormalTransformer"}) {
            try {
                Class<?> transformerClass = Class.forName(clz);
                Field field = transformerClass.getDeclaredField("squashBakedQuads");
                field.setAccessible(true);
                field.setBoolean(null, false);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String[] getASMTransformerClass() {
        return new String[]{"org.embeddedt.vintagefix.transformer.ASMModParserTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        if (JarDiscovererCache.isActive()) {
            JarDiscovererCache.load();
        }
        this.replaceLaunchCLCaches();
        return null;
    }

    private void replaceLaunchCLCaches() {
        if (!(VintageFixCore.class.getClassLoader() instanceof LaunchClassLoader)) {
            return;
        }
        LaunchClassLoader cl = (LaunchClassLoader)VintageFixCore.class.getClassLoader();
        try {
            ObfuscationReflectionHelper.findField(LaunchClassLoader.class, (String)"packageManifests").set(cl, new ConcurrentHashMap(){

                @Override
                public Object put(Object key, Object value) {
                    return null;
                }
            });
            Field resourceCacheField = ObfuscationReflectionHelper.findField(LaunchClassLoader.class, (String)"resourceCache");
            Map resourceCacheMap = (Map)resourceCacheField.get(cl);
            if (resourceCacheMap instanceof ConcurrentHashMap) {
                resourceCacheField.set(cl, CacheBuilder.newBuilder().maximumWeight(0x1400000L).weigher((k, v) -> k.length() + ((byte[])v).length).expireAfterAccess(1L, TimeUnit.MINUTES).build().asMap());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private static void applyMixinFix() {
        OPTIFINE = VintageFixCore.classExists("ofdev.launchwrapper.OptifineDevTweakerWrapper") || VintageFixCore.classExists("optifine.OptiFineForgeTweaker");
        SPONGE = VintageFixCore.classExists("org.spongepowered.mod.SpongeCoremod");
        VINTAGIUM = VintageFixCore.classExists("me.jellysquid.mods.sodium.client.SodiumMixinTweaker");
        try {
            Field groupMembersField = InjectorGroupInfo.class.getDeclaredField("members");
            groupMembersField.setAccessible(true);
            Field noGroupField = InjectorGroupInfo.Map.class.getDeclaredField("NO_GROUP");
            noGroupField.setAccessible(true);
            InjectorGroupInfo noGroup = (InjectorGroupInfo)noGroupField.get(null);
            groupMembersField.set(noGroup, new DummyList());
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
    }

    public List<String> getMixinConfigs() {
        if (!mixinFixApplied) {
            VintageFixCore.applyMixinFix();
            mixinFixApplied = true;
        }
        return ImmutableList.of((Object)"mixins.vintagefix.init.json", (Object)"mixins.vintagefix.json");
    }

    static {
        mixinFixApplied = false;
    }
}

