/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.embeddedt.vintagefix.VintageFix;

public class ModelLocationInformation {
    public static final boolean DEBUG_MODEL_LOAD = Boolean.getBoolean("vintagefix.debugDynamicModelLoading");
    private static Map<Item, List<String>> variantNames;
    public static final Map<ModelResourceLocation, ResourceLocation> inventoryVariantLocations;
    private static final Map<ResourceLocation, Block> blockstateLocationToBlock;
    public static final Set<ModelResourceLocation> allItemVariants;
    public static final Set<ModelResourceLocation> allKnownModelLocations;
    public static final Map<ResourceLocation, Collection<ModelResourceLocation>> validVariantsForBlock;
    private static final Object2IntOpenHashMap<String> errorsByNamespace;
    private static boolean firstInit;
    public static final CompletableFuture<Void> initFuture;
    private static final int ERROR_THRESHOLD = 6;

    private static void loadStaticVariants() {
        ResourceLocation itemFrame = new ResourceLocation("item_frame");
        allKnownModelLocations.add(new ModelResourceLocation(itemFrame, "normal"));
        allKnownModelLocations.add(new ModelResourceLocation(itemFrame, "map"));
    }

    public static void init(ModelLoader loader, BlockStateMapper blockStateMapper) {
        Method method = ObfuscationReflectionHelper.findMethod(ModelBakery.class, (String)"func_177592_e", Void.TYPE, (Class[])new Class[0]);
        try {
            method.invoke((Object)loader, new Object[0]);
            variantNames = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)loader, (String)"field_177613_u");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        errorsByNamespace.clear();
        if (firstInit) {
            inventoryVariantLocations.clear();
            blockstateLocationToBlock.clear();
            allItemVariants.clear();
            validVariantsForBlock.clear();
            for (Item item : Item.field_150901_e) {
                for (String s : ModelLocationInformation.getVariantNames(item)) {
                    ResourceLocation itemLocation = ModelLocationInformation.getItemLocation(s);
                    ModelResourceLocation inventoryVariant = ModelLocationInformation.getInventoryVariant(s);
                    allItemVariants.add(inventoryVariant);
                    allKnownModelLocations.add(inventoryVariant);
                    inventoryVariantLocations.put(inventoryVariant, itemLocation);
                }
            }
            for (Block block : Block.field_149771_c) {
                for (ResourceLocation location : blockStateMapper.func_188182_a(block)) {
                    blockstateLocationToBlock.put(location, block);
                }
                for (ResourceLocation location : blockStateMapper.func_188181_b(block).values()) {
                    allKnownModelLocations.add((ModelResourceLocation)location);
                    ResourceLocation baseLocation = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
                    ObjectOpenHashSet mrls = (ObjectOpenHashSet)validVariantsForBlock.computeIfAbsent(baseLocation, k -> new ObjectOpenHashSet());
                    mrls.add((Object)location);
                }
            }
            ModelLocationInformation.loadStaticVariants();
            for (Collection<ModelResourceLocation> c : validVariantsForBlock.values()) {
                ((ObjectOpenHashSet)c).trim();
            }
            initFuture.complete(null);
            firstInit = false;
        }
    }

    public static ResourceLocation getInventoryVariantLocation(ModelResourceLocation inventoryVariant) {
        return inventoryVariantLocations.get(inventoryVariant);
    }

    public static void addInventoryVariantLocation(ModelResourceLocation inventoryVariant, ResourceLocation location) {
        inventoryVariantLocations.put(inventoryVariant, location);
    }

    public static boolean isAppropriateMultipart(ResourceLocation block, ModelResourceLocation mrl) {
        Collection<ModelResourceLocation> collection = validVariantsForBlock.get(block);
        if (collection == null) {
            return false;
        }
        return collection.contains(mrl);
    }

    public static ResourceLocation getItemLocation(String location) {
        ResourceLocation resourcelocation = new ResourceLocation(location.replaceAll("#.*", ""));
        return new ResourceLocation(resourcelocation.func_110624_b(), "item/" + resourcelocation.func_110623_a());
    }

    public static ModelResourceLocation getInventoryVariant(String variant) {
        if (variant.contains("#")) {
            return new ModelResourceLocation(variant);
        }
        return new ModelResourceLocation(variant, "inventory");
    }

    public static List<String> getVariantNames(Item item) {
        List<String> list = variantNames.get(item);
        if (list == null) {
            list = Collections.singletonList(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString());
        }
        return list;
    }

    public static Block getBlockFromBlockstateLocation(ResourceLocation blockstateLocation) {
        return blockstateLocationToBlock.get(blockstateLocation);
    }

    public static ModelBlockDefinition loadModelBlockDefinition(ResourceLocation location) {
        ResourceLocation blockstateLocation = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
        ArrayList list = Lists.newArrayList();
        try {
            for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(blockstateLocation)) {
                list.add(ModelLocationInformation.loadModelBlockDefinition(location, resource));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered an exception when loading model definition of model " + blockstateLocation, e);
        }
        return new ModelBlockDefinition((List)list);
    }

    private static ModelBlockDefinition loadModelBlockDefinition(ResourceLocation location, IResource resource) {
        ModelBlockDefinition definition;
        try (InputStream is = resource.func_110527_b();){
            definition = ModelBlockDefinition.parseFromReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), (ResourceLocation)location);
        }
        catch (Exception exception) {
            throw new RuntimeException("Encountered an exception when loading model definition of '" + location + "' from: '" + resource.func_177241_a() + "' in resourcepack: '" + resource.func_177240_d() + "'", exception);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLogError(String namespace) {
        int curNumErrors;
        Object2IntOpenHashMap<String> object2IntOpenHashMap = errorsByNamespace;
        synchronized (object2IntOpenHashMap) {
            curNumErrors = errorsByNamespace.getInt((Object)namespace);
        }
        if (curNumErrors <= 6) {
            if (curNumErrors == 6) {
                VintageFix.LOGGER.error("Suppressing further model loading errors for namespace '{}'", (Object)namespace);
            }
            object2IntOpenHashMap = errorsByNamespace;
            synchronized (object2IntOpenHashMap) {
                errorsByNamespace.put((Object)namespace, curNumErrors + 1);
            }
            return curNumErrors < 6;
        }
        return false;
    }

    static {
        inventoryVariantLocations = new Object2ObjectOpenHashMap();
        blockstateLocationToBlock = new Object2ObjectOpenHashMap();
        allItemVariants = new ObjectOpenHashSet();
        allKnownModelLocations = new ObjectOpenHashSet();
        validVariantsForBlock = new Object2ObjectOpenHashMap();
        errorsByNamespace = new Object2IntOpenHashMap();
        errorsByNamespace.defaultReturnValue(0);
        firstInit = true;
        initFuture = new CompletableFuture();
    }
}

