/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.entity;

import com.enderio.base.common.init.EIOEntities;
import com.enderio.base.common.util.PaintUtils;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PaintedSandEntity
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    public PaintedSandEntity(EntityType<? extends FallingBlockEntity> type, Level level) {
        super(type, level);
    }

    public PaintedSandEntity(Level level, double x, double y, double z, BlockState state) {
        super(level, x, y, z, state);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityType<?> m_6095_() {
        return (EntityType)EIOEntities.PAINTED_SAND.get();
    }

    @Nullable
    public Block getPaint() {
        if (this.f_31944_ != null) {
            return PaintUtils.getBlockFromRL(this.f_31944_.m_128461_("Paint"));
        }
        return null;
    }

    public void setPaint(Block block) {
        if (this.f_31944_ == null) {
            this.f_31944_ = new CompoundTag();
        }
        this.f_31944_.m_128359_("Paint", Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Block block = this.getPaint();
        buffer.m_130085_(block != null ? Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)) : new ResourceLocation(""));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        ResourceLocation rl = additionalData.m_130281_();
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (block != null && block != Blocks.f_50016_) {
            this.setPaint(block);
        }
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (!stack.m_41619_() && this.f_31944_ != null) {
            CompoundTag itemNbt = new CompoundTag();
            itemNbt.m_128365_("BlockEntityTag", (Tag)this.f_31944_);
            stack.m_41751_(itemNbt);
        }
        return super.m_5552_(stack, offsetY);
    }
}

