/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.container.ModificationTableContainer;
import mod.chiselsandbits.utils.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModificationTableBlock
extends Block {
    private static final Component CONTAINER_NAME = Component.m_237115_((String)"block.chiselsandbits.modification_table");
    private static final Property<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape DEFAULT_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)4.0), Block.m_49796_((double)4.0, (double)8.0, (double)1.0, (double)12.0, (double)11.0, (double)15.0), Block.m_49796_((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0), Block.m_49796_((double)5.5, (double)2.0, (double)0.5, (double)7.5, (double)4.0, (double)8.5), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)11.0, (double)15.0), Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)6.0, (double)2.0, (double)8.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)2.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newHashMap();

    public ModificationTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (worldIn.m_5776_()) {
            return InteractionResult.PASS;
        }
        player.m_5893_(state.m_60750_(worldIn, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new ModificationTableContainer(id, inventory, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), CONTAINER_NAME);
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.ModificationTableHelp, tooltip, new Object[0]);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPES.get(pState.m_61143_(FACING));
    }

    static {
        SHAPES.put(Direction.NORTH, VoxelShapeUtils.rotateHorizontal(DEFAULT_SHAPE, Direction.SOUTH));
        SHAPES.put(Direction.SOUTH, VoxelShapeUtils.rotateHorizontal(DEFAULT_SHAPE, Direction.NORTH));
        SHAPES.put(Direction.WEST, VoxelShapeUtils.rotateHorizontal(DEFAULT_SHAPE, Direction.EAST));
        SHAPES.put(Direction.EAST, VoxelShapeUtils.rotateHorizontal(DEFAULT_SHAPE, Direction.WEST));
    }
}

