/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.MultiStateItemStackManager;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleUsePatternItem
extends Item
implements IPatternItem {
    public SingleUsePatternItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public Component m_7626_(ItemStack item) {
        if (!item.m_41784_().m_128441_("highlight")) {
            return super.m_7626_(item);
        }
        String highlightTextJson = item.m_41784_().m_128461_("highlight");
        return Component.Serializer.m_130701_((String)highlightTextJson).m_130940_(ChatFormatting.RED);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(ItemStack stack) {
        if (stack.m_41784_().m_128456_()) {
            return EmptySnapshot.Stack.INSTANCE;
        }
        return MultiStateItemStackManager.getInstance().getManagedStack(stack, SingleBlockMultiStateItemStack::new);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        IMultiStateItemStack contents = this.createItemStack(context.m_43722_());
        if (contents.getStatistics().isEmpty()) {
            if (context.m_43723_() == null) {
                return InteractionResult.FAIL;
            }
            if (!context.m_43723_().m_7500_()) {
                return InteractionResult.FAIL;
            }
            if (!context.m_43723_().m_6144_()) {
                return InteractionResult.FAIL;
            }
            IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((LevelAccessor)context.m_43725_(), context.m_8083_());
            ItemStack snapshotPatternStack = areaMutator.createSnapshot().toItemStack().toPatternStack();
            context.m_43722_().m_41751_(snapshotPatternStack.m_41784_().m_6426_());
            return InteractionResult.SUCCESS;
        }
        return this.tryPlace(new BlockPlaceContext(context));
    }

    @NotNull
    public InteractionResult tryPlace(@NotNull BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        IMultiStateItemStack source = this.createItemStack(context.m_43722_());
        IMultiStateSnapshot sourceSnapshot = source.createSnapshot();
        IPatternPlacementType mode = this.getMode(context.m_43722_());
        PlacementResult resultType = mode.performPlacement(sourceSnapshot, context, false);
        if (!resultType.isSuccess() && context.m_43725_().m_5776_()) {
            INotificationManager.getInstance().notify(mode.getIcon(), new Vec3(1.0, 0.0, 0.0), resultType.getFailureMessage());
        }
        return resultType.isSuccess() ? this.determineSuccessResult(context, context.m_43722_()) : InteractionResult.FAIL;
    }

    protected InteractionResult determineSuccessResult(BlockPlaceContext context, ItemStack stack) {
        if (context.m_43723_() != null && context.m_43723_().m_7500_()) {
            return InteractionResult.SUCCESS;
        }
        stack.m_41774_(1);
        return InteractionResult.CONSUME;
    }

    @Override
    @NotNull
    public ItemStack seal(@NotNull ItemStack source) throws SealingNotSupportedException {
        if (source.m_41720_() == this) {
            if (!(source.m_41720_() instanceof IMultiUsePatternItem)) {
                ItemStack seal = new ItemStack((ItemLike)ModItems.MULTI_USE_PATTERN_ITEM.get());
                seal.m_41751_(source.m_41784_().m_6426_());
                return seal;
            }
            throw new SealingNotSupportedException();
        }
        return source;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        IPatternPlacementType mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((Component)LocalStrings.PatternItemTooltipModeGrouped.getText(((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((Component)LocalStrings.PatternItemTooltipModeSimple.getText(mode.getDisplayName()));
        }
        if (Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)"        "));
            tooltip.add((Component)Component.m_237113_((String)"        "));
            HelpTextUtils.build(LocalStrings.HelpSimplePattern, tooltip, new Object[0]);
        }
    }

    @Override
    @NotNull
    public IPatternPlacementType getMode(ItemStack stack) {
        return ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().get(stack.m_41784_().m_128441_("mode") ? new ResourceLocation(stack.m_41784_().m_128461_("mode")) : ModPatternPlacementTypes.PLACEMENT.getId()).orElse((IPatternPlacementType)ModPatternPlacementTypes.PLACEMENT.get());
    }

    @Override
    public void setMode(ItemStack stack, IPatternPlacementType mode) {
        stack.m_41784_().m_128359_("mode", mode.getRegistryName().toString());
    }

    @Override
    @NotNull
    public Collection<IPatternPlacementType> getPossibleModes() {
        return ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().getValues();
    }
}

