/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.forge.citresewn.pack.cits;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Axis;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;
import shcm.shsupercm.forge.citresewn.config.CITResewnConfig;
import shcm.shsupercm.forge.citresewn.ex.CITParseException;
import shcm.shsupercm.forge.citresewn.mixin.citenchantment.BufferBuilderStorageAccessor;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;
import shcm.shsupercm.util.logic.Loops;

public class CITEnchantment
extends CIT {
    public static List<CITEnchantment> appliedContext = null;
    public static boolean shouldApply = false;
    public final ResourceLocation textureIdentifier;
    public final float speed;
    public final float rotation;
    public final float duration;
    public final float r;
    public final float g;
    public final float b;
    public final float a;
    public final int layer;
    public final boolean useGlint;
    public final boolean blur;
    public final Blend blend;
    private final WrappedMethodIntensity methodIntensity = new WrappedMethodIntensity();
    public final Map<Dummy.GlintRenderLayer, RenderType> renderLayers = new EnumMap<Dummy.GlintRenderLayer, RenderType>(Dummy.GlintRenderLayer.class);

    public CITEnchantment(CITPack pack, ResourceLocation identifier, Properties properties) throws CITParseException {
        super(pack, identifier, properties);
        try {
            this.textureIdentifier = CITEnchantment.resolvePath(identifier, properties.getProperty("texture"), ".png", Minecraft.m_91087_().m_91098_());
            if (this.textureIdentifier == null) {
                throw new Exception("Cannot resolve texture");
            }
            this.speed = Float.parseFloat(properties.getProperty("speed", "1"));
            this.rotation = Float.parseFloat(properties.getProperty("rotation", "0"));
            this.duration = Float.max(0.0f, Float.parseFloat(properties.getProperty("duration", "0")));
            this.layer = Integer.parseInt(properties.getProperty("layer", "0"));
            this.r = Math.max(0.0f, Float.parseFloat(properties.getProperty("r", "1")));
            this.g = Math.max(0.0f, Float.parseFloat(properties.getProperty("g", "1")));
            this.b = Math.max(0.0f, Float.parseFloat(properties.getProperty("b", "1")));
            this.a = Math.max(0.0f, Float.parseFloat(properties.getProperty("a", "1")));
            this.useGlint = switch (properties.getProperty("useGlint", "false").toLowerCase(Locale.ENGLISH)) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new Exception("useGlint is not a boolean");
            };
            this.blur = switch (properties.getProperty("blur", "true").toLowerCase(Locale.ENGLISH)) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new Exception("blur is not a boolean");
            };
            this.blend = Blend.getBlend(properties.getProperty("blend", "add"));
        }
        catch (Exception e) {
            throw new CITParseException(pack.resourcePack, identifier, (String)(e.getClass() == Exception.class ? "" : e.getClass().getSimpleName() + ": ") + e.getMessage());
        }
    }

    public void activate() {
        for (Dummy.GlintRenderLayer glintLayer : Dummy.GlintRenderLayer.values()) {
            RenderType renderLayer = glintLayer.build(this);
            this.renderLayers.put(glintLayer, renderLayer);
            ((BufferBuilderStorageAccessor)Minecraft.m_91087_().m_91269_()).entityBuilders().put(renderLayer, new BufferBuilder(renderLayer.m_110507_()));
        }
    }

    @Override
    public void dispose() {
        appliedContext = null;
        for (RenderType renderLayer : this.renderLayers.values()) {
            ((BufferBuilderStorageAccessor)Minecraft.m_91087_().m_91269_()).entityBuilders().remove(renderLayer);
        }
    }

    private static class WrappedMethodIntensity {
        public float intensity = 1.0f;

        private WrappedMethodIntensity() {
        }
    }

    public static abstract class Dummy
    extends RenderStateShard {
        public Dummy(String pName, Runnable pSetupState, Runnable pClearState) {
            super(pName, pSetupState, pClearState);
        }

        public static enum GlintRenderLayer {
            ARMOR_GLINT("armor_glint", 8.0f, layer -> layer.m_173292_(f_173078_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110669_(f_110119_)),
            ARMOR_ENTITY_GLINT("armor_entity_glint", 0.16f, layer -> layer.m_173292_(f_173079_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110669_(f_110119_)),
            GLINT_TRANSLUCENT("glint_translucent", 8.0f, layer -> layer.m_173292_(f_173080_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110675_(f_110129_)),
            GLINT("glint", 8.0f, layer -> layer.m_173292_(f_173081_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_)),
            DIRECT_GLINT("glint_direct", 8.0f, layer -> layer.m_173292_(f_173082_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_)),
            ENTITY_GLINT("entity_glint", 0.16f, layer -> layer.m_173292_(f_173083_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110675_(f_110129_)),
            DIRECT_ENTITY_GLINT("entity_glint_direct", 0.16f, layer -> layer.m_173292_(f_173084_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_));

            public final String name;
            private final Consumer<RenderType.CompositeState.CompositeStateBuilder> setup;
            private final float scale;

            private GlintRenderLayer(String name, float scale, Consumer<RenderType.CompositeState.CompositeStateBuilder> setup) {
                this.name = name;
                this.scale = scale;
                this.setup = setup;
            }

            public RenderType build(CITEnchantment enchantment) {
                float speed = enchantment.speed;
                float rotation = enchantment.rotation;
                float r = enchantment.r;
                float g = enchantment.g;
                float b = enchantment.b;
                float a = enchantment.a;
                WrappedMethodIntensity methodIntensity = enchantment.methodIntensity;
                RenderType.CompositeState.CompositeStateBuilder layer = RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(enchantment.textureIdentifier, enchantment.blur, false)).m_110683_(new RenderStateShard.TexturingStateShard("citresewn_glint_texturing", () -> {
                    float l = (float)Util.m_137550_() * CITResewnConfig.INSTANCE().citenchantment_scroll_multiplier * speed;
                    float x = l % 110000.0f / 110000.0f;
                    float y = l % 30000.0f / 30000.0f;
                    Matrix4f matrix4f = new Matrix4f().translation(-x, y, 0.0f);
                    matrix4f.rotate((Quaternionfc)Axis.f_252403_.m_252977_(rotation + 10.0f));
                    matrix4f.mul((Matrix4fc)new Matrix4f().scale(this.scale, this.scale, this.scale));
                    RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
                    RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(a * methodIntensity.intensity));
                }, () -> {
                    RenderSystem.resetTextureMatrix();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                })).m_110685_((RenderStateShard.TransparencyStateShard)enchantment.blend);
                this.setup.accept(layer);
                return RenderType.m_173215_((String)("citresewn:enchantment_" + this.name + ":" + enchantment.propertiesIdentifier.toString()), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)layer.m_110691_(false));
            }

            public VertexConsumer tryApply(VertexConsumer base, RenderType baseLayer, MultiBufferSource provider) {
                if (!shouldApply || appliedContext == null || appliedContext.size() == 0) {
                    return null;
                }
                VertexConsumer[] layers = new VertexConsumer[Math.min(appliedContext.size(), CITEnchantment.appliedContext.get((int)0).pack.cap)];
                for (int i = 0; i < layers.length; ++i) {
                    layers[i] = provider.m_6299_(CITEnchantment.appliedContext.get((int)i).renderLayers.get((Object)this));
                }
                provider.m_6299_(baseLayer);
                return base == null ? VertexMultiConsumer.m_167063_((VertexConsumer[])layers) : VertexMultiConsumer.m_86168_((VertexConsumer)VertexMultiConsumer.m_167063_((VertexConsumer[])layers), (VertexConsumer)base);
            }
        }
    }

    public static class Blend
    extends RenderStateShard.TransparencyStateShard {
        private final int src;
        private final int dst;
        private final int srcAlpha;
        private final int dstAlpha;

        private Blend(String name, int src, int dst, int srcAlpha, int dstAlpha) {
            super(name + "_glint_transparency", null, null);
            this.src = src;
            this.dst = dst;
            this.srcAlpha = srcAlpha;
            this.dstAlpha = dstAlpha;
        }

        private Blend(String name, int src, int dst) {
            this(name, src, dst, 0, 1);
        }

        public void m_110185_() {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)this.src, (int)this.dst, (int)this.srcAlpha, (int)this.dstAlpha);
        }

        public void m_110188_() {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
        }

        public static Blend getBlend(String blendString) throws BlendFormatException {
            try {
                return Named.valueOf((String)blendString.toUpperCase((Locale)Locale.ENGLISH)).blend;
            }
            catch (IllegalArgumentException ignored) {
                try {
                    int dstAlpha;
                    int srcAlpha;
                    int dst;
                    int src;
                    String[] split = blendString.split(" ");
                    if (split.length == 2) {
                        src = Blend.parseGLConstant(split[0]);
                        dst = Blend.parseGLConstant(split[1]);
                        srcAlpha = 0;
                        dstAlpha = 1;
                    } else if (split.length == 4) {
                        src = Blend.parseGLConstant(split[0]);
                        dst = Blend.parseGLConstant(split[1]);
                        srcAlpha = Blend.parseGLConstant(split[2]);
                        dstAlpha = Blend.parseGLConstant(split[3]);
                    } else {
                        throw new Exception();
                    }
                    return new Blend("custom_" + src + "_" + dst + "_" + srcAlpha + "_" + dstAlpha, src, dst, srcAlpha, dstAlpha);
                }
                catch (Exception e) {
                    throw new BlendFormatException();
                }
            }
        }

        private static int parseGLConstant(String s) throws Exception {
            try {
                return GL11.class.getDeclaredField(s).getInt(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return s.startsWith("0x") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
            }
        }

        private static enum Named {
            REPLACE(new Blend("replace", 0, 0){

                @Override
                public void m_110185_() {
                    RenderSystem.disableBlend();
                }
            }),
            GLINT(new Blend("glint", 768, 1)),
            ALPHA(new Blend("alpha", 770, 771)),
            ADD(new Blend("add", 770, 1)),
            SUBTRACT(new Blend("subtract", 775, 0)),
            MULTIPLY(new Blend("multiply", 774, 771)),
            DODGE(new Blend("dodge", 1, 1)),
            BURN(new Blend("burn", 0, 769)),
            SCREEN(new Blend("screen", 1, 769)),
            OVERLAY(new Blend("overlay", 774, 768));

            public final Blend blend;

            private Named(Blend blend) {
                this.blend = blend;
            }
        }

        public static class BlendFormatException
        extends Exception {
            public BlendFormatException() {
                super("Not a valid blending method");
            }
        }
    }

    public static interface Cached {
        public List<CITEnchantment> citresewn_getCachedCITEnchantment(Supplier<List<CITEnchantment>> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MergeMethod {
        AVERAGE{

            @Override
            public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CITEnchantment cit) {
                ResourceLocation enchantment = null;
                for (ResourceLocation enchantmentMatch : cit.enchantments) {
                    if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                    enchantment = enchantmentMatch;
                    break;
                }
                if (enchantment == null) {
                    cit.methodIntensity.intensity = 0.0f;
                } else {
                    float sum = 0.0f;
                    for (Integer value : stackEnchantments.values()) {
                        sum += (float)value.intValue();
                    }
                    cit.methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / sum;
                }
            }
        }
        ,
        LAYERED{

            @Override
            public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CITEnchantment cit) {
                ResourceLocation enchantment = null;
                for (ResourceLocation enchantmentMatch : cit.enchantments) {
                    if (!stackEnchantments.containsKey(enchantmentMatch)) continue;
                    enchantment = enchantmentMatch;
                    break;
                }
                if (enchantment == null) {
                    cit.methodIntensity.intensity = 0.0f;
                    return;
                }
                float max = 0.0f;
                for (Integer value : stackEnchantments.values()) {
                    if (!((float)value.intValue() > max)) continue;
                    max = value.intValue();
                }
                cit.methodIntensity.intensity = (float)stackEnchantments.get(enchantment).intValue() / max;
            }
        }
        ,
        CYCLE{

            @Override
            public void applyMethod(List<CITEnchantment> citEnchantments, ItemStack stack) {
                ArrayList durations = new ArrayList();
                for (CITEnchantment cITEnchantment : citEnchantments) {
                    durations.add(new AbstractMap.SimpleEntry<CITEnchantment, Float>(cITEnchantment, Float.valueOf(cITEnchantment.duration)));
                }
                for (Map.Entry entry : Loops.statelessFadingLoop(durations, citEnchantments.get((int)0).pack.fade.floatValue(), ticks, 20).entrySet()) {
                    ((CITEnchantment)entry.getKey()).methodIntensity.intensity = ((Float)entry.getValue()).floatValue();
                }
            }
        };

        public static int ticks;

        public void applyIntensity(Map<ResourceLocation, Integer> stackEnchantments, CITEnchantment cit) {
            cit.methodIntensity.intensity = 1.0f;
        }

        public void applyMethod(List<CITEnchantment> citEnchantments, ItemStack stack) {
            LinkedHashMap<ResourceLocation, Integer> stackEnchantments = new LinkedHashMap<ResourceLocation, Integer>();
            for (Tag nbtElement : stack.m_150930_(Items.f_42690_) ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_()) {
                stackEnchantments.put(EnchantmentHelper.m_182446_((CompoundTag)((CompoundTag)nbtElement)), EnchantmentHelper.m_182438_((CompoundTag)((CompoundTag)nbtElement)));
            }
            for (CITEnchantment cit : citEnchantments) {
                if (cit.enchantmentsAny) continue;
                this.applyIntensity(stackEnchantments, cit);
            }
        }

        static {
            ticks = 0;
        }
    }
}

