/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.block;

import cofh.core.common.config.CoreCommonConfig;
import cofh.lib.api.block.IDismantleable;
import cofh.lib.api.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DetectorRailBlockCoFH
extends DetectorRailBlock
implements IDismantleable,
IWrenchable {
    protected float maxSpeed = 0.4f;

    public DetectorRailBlockCoFH(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public DetectorRailBlockCoFH speed(float maxSpeed) {
        this.maxSpeed = MathHelper.clamp(maxSpeed, 0.0f, 1.0f);
        return this;
    }

    public float getRailMaxSpeed(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        return this.maxSpeed;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Utils.isWrench(player.m_21120_(handIn))) {
            if (player.m_36341_()) {
                if (this.canDismantle(worldIn, pos, state, player)) {
                    this.dismantleBlock(worldIn, pos, state, (HitResult)hit, player, CoreCommonConfig.returnDismantleDrops());
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState rotState = this.rotate(state, (LevelAccessor)worldIn, pos, Rotation.CLOCKWISE_90);
                if (rotState != state) {
                    worldIn.m_46597_(pos, rotState);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

