/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.gui.recipes.RecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeSortUtil {
    private static final Comparator<RecipeLayoutWithButtons<?>> CRAFTABLE_COMPARATOR = RecipeSortUtil.createCraftableComparator();

    public static List<IRecipeCategory<?>> sortRecipeCategories(List<IRecipeCategory<?>> recipeCategories, IRecipeTransferManager recipeTransferManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return recipeCategories;
        }
        AbstractContainerMenu openContainer = player.f_36096_;
        if (openContainer == null) {
            return recipeCategories;
        }
        Comparator<IRecipeCategory> comparator = Comparator.comparing(r -> {
            Optional recipeTransferHandler = recipeTransferManager.getRecipeTransferHandler(openContainer, r);
            return recipeTransferHandler.isPresent();
        }).reversed();
        return recipeCategories.stream().sorted(comparator).toList();
    }

    public static Comparator<RecipeLayoutWithButtons<?>> getCraftableComparator() {
        return CRAFTABLE_COMPARATOR;
    }

    private static Comparator<RecipeLayoutWithButtons<?>> createCraftableComparator() {
        return Comparator.comparingInt(r -> {
            IRecipeLayoutDrawable recipeLayout = r.recipeLayout();
            List<IRecipeSlotView> inputSlotViews = recipeLayout.getRecipeSlotsView().getSlotViews(RecipeIngredientRole.INPUT);
            RecipeTransferButton transferButton = r.transferButton();
            int missingCount = transferButton.getMissingCountHint();
            if (missingCount == -1) {
                return 0;
            }
            int ingredientCount = RecipeSortUtil.ingredientCount(inputSlotViews);
            if (ingredientCount == 0) {
                return 0;
            }
            int matchCount = ingredientCount - missingCount;
            int matchPercent = 100 * matchCount / ingredientCount;
            return -matchPercent;
        });
    }

    private static int ingredientCount(List<IRecipeSlotView> inputSlotViews) {
        int count = 0;
        for (IRecipeSlotView i : inputSlotViews) {
            if (i.isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

