/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.kube;

import com.almostreliable.kubeio.enderio.CustomConduitEntry;
import com.almostreliable.kubeio.kube.event.ConduitRegistryEvent;
import com.almostreliable.kubeio.kube.schema.AlloySmelterRecipeSchema;
import com.almostreliable.kubeio.kube.schema.EnchanterRecipeSchema;
import com.almostreliable.kubeio.kube.schema.FireCraftingRecipeSchema;
import com.almostreliable.kubeio.kube.schema.GrindingBallRecipeSchema;
import com.almostreliable.kubeio.kube.schema.PaintingRecipeSchema;
import com.almostreliable.kubeio.kube.schema.SagMillRecipeSchema;
import com.almostreliable.kubeio.kube.schema.SlicerRecipeSchema;
import com.almostreliable.kubeio.kube.schema.SoulBinderRecipeSchema;
import com.almostreliable.kubeio.kube.schema.TankRecipeSchema;
import com.almostreliable.kubeio.mixin.AlloySmeltingRecipeAccessor;
import com.enderio.EnderIO;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.core.common.recipes.RecipeTypeSerializerPair;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class KubePlugin
extends KubeJSPlugin {
    public static final Set<ResourceLocation> SMELTING_RECIPES = new HashSet<ResourceLocation>();

    public void registerEvents() {
        Events.GROUP.register();
    }

    public void registerBindings(BindingsEvent event) {
        if (event.getType().isServer()) {
            event.add("MobCategory", MobCategory.class);
            event.add("EnderIOBonusType", SagMillingRecipe.BonusType.class);
        }
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(CountedIngredient.class, (cx, o) -> KubePlugin.wrapCountedIngredient(o));
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        for (CustomConduitEntry conduit : ConduitRegistryEvent.CONDUITS) {
            generator.itemModel(EnderIO.loc((String)conduit.id()), modelGenerator -> {
                modelGenerator.parent(EnderIO.loc((String)"item/conduit").toString());
                modelGenerator.texture("0", EnderIO.loc((String)("block/conduit/" + conduit.id())).toString());
            });
        }
    }

    public void generateLang(LangEventJS event) {
        for (CustomConduitEntry conduit : ConduitRegistryEvent.CONDUITS) {
            event.add("item.enderio." + conduit.id(), conduit.name());
        }
    }

    public void injectRuntimeRecipes(RecipesEventJS event, RecipeManager manager, Map<ResourceLocation, Recipe<?>> recipesByName) {
        for (ResourceLocation recipeId : SMELTING_RECIPES) {
            AlloySmeltingRecipe r;
            AlloySmeltingRecipeAccessor smeltingRecipe;
            List<CountedIngredient> inputs;
            Recipe<?> recipe = recipesByName.get(recipeId);
            if (!(recipe instanceof AlloySmeltingRecipe) || (inputs = (smeltingRecipe = (AlloySmeltingRecipeAccessor)(r = (AlloySmeltingRecipe)recipe)).getInputs()).size() != 1 || inputs.get(0).count() != 1) continue;
            Ingredient input = inputs.get(0).ingredient();
            ItemStack output = smeltingRecipe.getOutput();
            float experience = smeltingRecipe.getExperience();
            ResourceLocation id = new ResourceLocation(recipeId.toString() + "_inherited");
            recipesByName.put(id, (Recipe<?>)new SmeltingRecipe(id, "", CookingBookCategory.MISC, input, output, experience, 200));
        }
        SMELTING_RECIPES.clear();
    }

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        Map<RecipeTypeSerializerPair, RecipeSchema> basicRecipeSchemas = Map.of(EIORecipes.FIRE_CRAFTING, FireCraftingRecipeSchema.SCHEMA, EIORecipes.GRINDING_BALL, GrindingBallRecipeSchema.SCHEMA);
        Map<RecipeTypeSerializerPair, RecipeSchema> machineRecipeSchemas = Map.of(MachineRecipes.ALLOY_SMELTING, AlloySmelterRecipeSchema.SCHEMA, MachineRecipes.ENCHANTING, EnchanterRecipeSchema.SCHEMA, MachineRecipes.PAINTING, PaintingRecipeSchema.SCHEMA, MachineRecipes.SAG_MILLING, SagMillRecipeSchema.SCHEMA, MachineRecipes.SLICING, SlicerRecipeSchema.SCHEMA, MachineRecipes.SOUL_BINDING, SoulBinderRecipeSchema.SCHEMA, MachineRecipes.TANK, TankRecipeSchema.SCHEMA);
        RecipeNamespace namespace = event.namespace("enderio");
        for (Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> entry : basicRecipeSchemas.entrySet()) {
            this.registerRecipeSchema(namespace, entry);
        }
        for (Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> entry : machineRecipeSchemas.entrySet()) {
            this.registerRecipeSchema(namespace, entry);
        }
    }

    private void registerRecipeSchema(RecipeNamespace namespace, Map.Entry<RecipeTypeSerializerPair<?, ?>, RecipeSchema> schemaEntry) {
        String id = schemaEntry.getKey().type().getId().m_135815_();
        namespace.register(id, schemaEntry.getValue());
    }

    public static CountedIngredient wrapCountedIngredient(Object o) {
        Map map;
        if (o instanceof CountedIngredient) {
            CountedIngredient countedIngredient = (CountedIngredient)o;
            return countedIngredient;
        }
        if (o instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)o;
            return CountedIngredient.fromJson((JsonObject)jsonObject);
        }
        if (o instanceof Map && (map = (Map)o).containsKey("ingredient") && map.containsKey("count")) {
            JsonObject jsonObject = MapJS.json((Object)map);
            if (jsonObject == null) {
                throw new IllegalArgumentException("Invalid counted ingredient: " + map);
            }
            return KubePlugin.wrapCountedIngredient(jsonObject);
        }
        InputItem inputItem = InputItem.of((Object)o);
        return CountedIngredient.of((int)inputItem.count, (Ingredient)inputItem.ingredient);
    }

    public static interface Events {
        public static final EventGroup GROUP = EventGroup.of((String)"EnderIOEvents");
        public static final EventHandler CONDUIT_REGISTRY = GROUP.startup("conduits", () -> ConduitRegistryEvent.class);
    }
}

