/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.entities.hook;

import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.entities.ReHookedEntities;
import com.oe.rehooked.sound.ReHookedSounds;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.HandlerHelper;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HookEntity
extends Projectile {
    private static final EntityDataAccessor<Optional<BlockPos>> HIT_POS = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREV_STATE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vector3f> DELTA_MOVEMENT = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Integer> REASON = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> HOOK_TYPE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RENDER_PARTICLES = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Vector3f> DIRECTION = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    protected int ticksInState = 0;
    protected boolean firstTickInState = true;
    protected Vec3 offset;
    protected int ticksSinceParticles = 0;

    public HookEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean m_142389_() {
        return true;
    }

    protected boolean m_5603_(@NotNull Entity pTarget) {
        return false;
    }

    public HookEntity(Player player) {
        super((EntityType)ReHookedEntities.HOOK_PROJECTILE.get(), player.m_9236_());
        this.m_20242_(true);
        this.f_19811_ = true;
        this.m_5602_((Entity)player);
        this.m_146884_(player.m_146892_());
        CurioUtils.GetHookType(player).ifPresent(this::setHookType);
    }

    public boolean m_6783_(double pDistance) {
        return this.getHookData().map(hookData -> pDistance < (double)(hookData.range() * hookData.range())).orElse(false);
    }

    public void m_5602_(@Nullable Entity pOwner) {
        super.m_5602_(pOwner);
        this.setOwnerId(pOwner != null ? pOwner.m_19879_() : -1);
    }

    public void m_8119_() {
        Player owner;
        Player owner2;
        Entity entity;
        if (!(this.m_9236_().m_5776_() || this.getState().equals((Object)State.DONE) || (entity = this.m_19749_()) instanceof Player && (owner2 = (Player)entity).m_6084_())) {
            this.setState(State.DONE);
        }
        if (!this.m_9236_().m_5776_()) {
            this.handleSounds();
        }
        switch (this.getState()) {
            case SHOT: {
                this.tickShot();
                break;
            }
            case PULLING: {
                this.tickPulling();
                break;
            }
            case RETRACTING: {
                this.tickRetracting();
                break;
            }
            case DONE: {
                if (this.m_9236_().m_5776_()) break;
                this.m_146870_();
            }
        }
        Vec3 dV = this.m_20184_();
        if (this.getPrevState().equals((Object)State.SHOT)) {
            this.m_6034_(this.m_20185_() + dV.f_82479_, this.m_20186_() + dV.f_82480_, this.m_20189_() + dV.f_82481_);
            if (this.getHitPos().isPresent() && this.tryGetOwnerFromCachedId() != null) {
                Vector3f scaled = this.getShotDirection().normalize().mul(0.15f);
                this.m_6034_(this.m_20185_() - (double)scaled.x, this.m_20186_() - (double)scaled.y, this.m_20189_() - (double)scaled.z);
            }
        } else if (this.getPrevState().equals((Object)State.RETRACTING)) {
            this.m_6034_(this.m_20185_() + dV.f_82479_, this.m_20186_() + dV.f_82480_, this.m_20189_() + dV.f_82481_);
        }
        this.trackTicksInState();
        if (this.offset == null && (owner = this.tryGetOwnerFromCachedId()) != null) {
            this.offset = this.m_20182_().m_82505_(owner.m_20182_().m_82520_(0.0, (double)owner.m_20192_() - 0.1, 0.0)).m_82541_();
        }
        if (this.m_9236_().m_5776_()) {
            this.createParticles();
        }
        super.m_8119_();
    }

    protected void handleSounds() {
        boolean handledReason = false;
        switch (this.getReason()) {
            case SHOT: {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ReHookedSounds.HOOK_SHOOT.get(), SoundSource.PLAYERS, 0.2f, 0.5f);
                handledReason = true;
                break;
            }
            case HIT: {
                this.getHitPos().ifPresent(hitPos -> {
                    SoundType soundType = this.m_9236_().m_8055_(hitPos).m_60827_();
                    this.m_9236_().m_6263_(null, (double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_(), soundType.m_56778_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
                    this.m_9236_().m_6263_(null, (double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_(), (SoundEvent)ReHookedSounds.HOOK_HIT.get(), SoundSource.BLOCKS, 0.35f, 0.5f);
                });
                handledReason = true;
                break;
            }
            case MISS: 
            case BREAK: {
                Entity entity = this.m_19749_();
                if (entity instanceof Player) {
                    Player owner = (Player)entity;
                    this.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)ReHookedSounds.HOOK_MISS.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                handledReason = true;
                break;
            }
            case PLAYER: {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ReHookedSounds.HOOK_RETRACT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                handledReason = true;
            }
        }
        if (handledReason) {
            this.setReason(Reason.EMPTY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void createParticles() {
        ++this.ticksSinceParticles;
        this.getHookData().ifPresent(hookData -> {
            if (this.ticksSinceParticles >= hookData.ticksBetweenSpawns() || this.getState().equals((Object)State.PULLING) && !this.getRenderParticles()) {
                return;
            }
            this.ticksSinceParticles = 0;
            ParticleOptions particleType = hookData.particleType().get();
            if (particleType == null) {
                return;
            }
            Player owner = this.tryGetOwnerFromCachedId();
            if (owner != null) {
                Vec3 ownerWaist = PositionHelper.getWaistPosition((Entity)owner);
                Vec3 particleSpeed = owner.m_20184_().m_82548_().m_82490_(0.8);
                double rDist = ownerWaist.m_82554_(this.m_20182_()) + 1.0;
                int i = 0;
                while ((double)i < rDist) {
                    int numParticles = this.f_19796_.m_216332_(hookData.minParticlesPerBlock(), hookData.maxParticlesPerBlock());
                    for (int k = 0; k < numParticles; ++k) {
                        double lerpX = Mth.m_14139_((double)((double)((float)i + 1.0f / (float)numParticles * (float)k) / rDist), (double)ownerWaist.f_82479_, (double)this.m_20185_());
                        double lerpY = Mth.m_14139_((double)((double)((float)i + 1.0f / (float)numParticles * (float)k) / rDist), (double)ownerWaist.f_82480_, (double)this.m_20186_());
                        double lerpZ = Mth.m_14139_((double)((double)((float)i + 1.0f / (float)numParticles * (float)k) / rDist), (double)ownerWaist.f_82481_, (double)this.m_20189_());
                        this.m_9236_().m_7106_(particleType, lerpX + Math.random() * hookData.radius(), lerpY + Math.random() * hookData.radius(), lerpZ + Math.random() * hookData.radius(), particleSpeed.f_82479_, particleSpeed.f_82480_, particleSpeed.f_82481_);
                    }
                    ++i;
                }
            }
        });
    }

    public void m_20256_(Vec3 pDeltaMovement) {
        this.setSharedDeltaV(pDeltaMovement.m_252839_());
        super.m_20256_(pDeltaMovement);
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(this.getSharedDeltaV());
    }

    public void m_37251_(@NotNull Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, pVelocity, pInaccuracy);
        this.setShotDirection(this.m_20184_().m_82541_().m_252839_());
        this.setReason(Reason.SHOT);
    }

    protected void tickShot() {
        Optional<HookData> optHookData = this.getHookData();
        if (optHookData.isPresent()) {
            HookData hookData = optHookData.get();
            if (!this.m_9236_().m_5776_() && !this.firstTickInState && hookData.speed() / 20.0f >= hookData.range()) {
                this.setReason(Reason.MISS);
                this.setState(State.RETRACTING);
                this.m_20256_(Vec3.f_82478_);
                return;
            }
            Player owner = this.tryGetOwnerFromCachedId();
            if (owner != null) {
                if (PositionHelper.getWaistPosition((Entity)owner).m_82554_(this.m_20182_()) > (double)hookData.range()) {
                    this.setReason(Reason.MISS);
                    this.setState(State.RETRACTING);
                    this.m_20256_(Vec3.f_82478_);
                } else {
                    BlockHitResult hitResult = VectorHelper.getFromEntityAndAngle((Entity)this, this.m_20184_().m_82541_(), this.m_20184_().m_82553_());
                    BlockState hitState = this.m_9236_().m_8055_(hitResult.m_82425_());
                    if (!hitState.m_60795_() && hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                        Vec3 hitLocation = hitResult.m_82450_();
                        this.m_20256_(this.m_20182_().m_82505_(hitLocation));
                        if (!this.m_9236_().m_5776_()) {
                            this.setReason(Reason.HIT);
                            this.setState(State.PULLING);
                            this.setHitPos(hitResult.m_82425_());
                            this.setShotDirection(this.m_20182_().m_82505_(hitLocation).m_252839_());
                        }
                    }
                }
            }
        }
    }

    protected void tickPulling() {
        if (this.firstTickInState) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.getHitPos().ifPresent(hitPos -> {
            if (this.m_9236_().m_8055_(hitPos).m_60795_()) {
                this.setReason(Reason.BREAK);
                this.setState(State.RETRACTING);
            }
        });
    }

    protected void tickRetracting() {
        Entity entity;
        if (!this.m_9236_().m_5776_() && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            Vec3 vectorToPlayer = this.m_20182_().m_82505_(PositionHelper.getWaistPosition((Entity)owner));
            this.setShotDirection(vectorToPlayer.m_252839_());
            if (vectorToPlayer.m_82553_() < 5.0) {
                HandlerHelper.getHookHandler(owner).ifPresent(handler -> {
                    handler.removeHook(this);
                    handler.killHook(this.m_19879_());
                });
            }
            this.getHookData().ifPresent(hookData -> {
                float speedModifier = hookData.speed() == Float.MAX_VALUE ? hookData.range() : hookData.speed() / 10.0f;
                speedModifier += (float)owner.m_20184_().m_82553_();
                if (vectorToPlayer.m_82553_() > (double)speedModifier) {
                    this.m_20256_(vectorToPlayer.m_82541_().m_82490_((double)speedModifier));
                } else {
                    this.m_20256_(vectorToPlayer);
                }
            });
        }
    }

    protected void trackTicksInState() {
        State currState = this.getState();
        if (currState.equals((Object)this.getPrevState())) {
            ++this.ticksInState;
            this.firstTickInState = false;
        } else {
            this.firstTickInState = true;
            this.ticksInState = 0;
            this.setPrevState(currState);
        }
    }

    public boolean hasChain() {
        return this.getHookData().map(hookData -> !(hookData.particleType().get() != null || this.getState().equals((Object)State.RETRACTING) && hookData.speed() / 20.0f >= hookData.range())).orElse(false);
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public State getState() {
        return State.values()[(Integer)this.f_19804_.m_135370_(STATE)];
    }

    protected void setHitPos(BlockPos hitPos) {
        this.f_19804_.m_135381_(HIT_POS, Optional.ofNullable(hitPos));
    }

    public Optional<BlockPos> getHitPos() {
        return (Optional)this.f_19804_.m_135370_(HIT_POS);
    }

    public Optional<HookData> getHookData() {
        return HookRegistry.getHookData(this.getHookType());
    }

    public String getHookType() {
        return (String)this.f_19804_.m_135370_(HOOK_TYPE);
    }

    public void setHookType(String hookType) {
        this.f_19804_.m_135381_(HOOK_TYPE, (Object)hookType);
    }

    protected void setPrevState(State state) {
        this.f_19804_.m_135381_(PREV_STATE, (Object)state.ordinal());
    }

    public State getPrevState() {
        return State.values()[(Integer)this.f_19804_.m_135370_(PREV_STATE)];
    }

    protected void setSharedDeltaV(Vector3f deltaV) {
        this.f_19804_.m_135381_(DELTA_MOVEMENT, (Object)deltaV);
    }

    public Vector3f getSharedDeltaV() {
        return (Vector3f)this.f_19804_.m_135370_(DELTA_MOVEMENT);
    }

    public void setReason(Reason reason) {
        this.f_19804_.m_135381_(REASON, (Object)reason.ordinal());
    }

    public Reason getReason() {
        return Reason.values()[(Integer)this.f_19804_.m_135370_(REASON)];
    }

    public Integer getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_ID);
    }

    public void setOwnerId(Integer id) {
        this.f_19804_.m_135381_(OWNER_ID, (Object)id);
    }

    public Player tryGetOwnerFromCachedId() {
        Entity entity = this.m_9236_().m_6815_(this.getOwnerId().intValue());
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            return owner;
        }
        return null;
    }

    public void setRenderParticles(boolean renderParticles) {
        this.f_19804_.m_135381_(RENDER_PARTICLES, (Object)renderParticles);
    }

    public boolean getRenderParticles() {
        return (Boolean)this.f_19804_.m_135370_(RENDER_PARTICLES);
    }

    public void setShotDirection(Vector3f direction) {
        this.f_19804_.m_135381_(DIRECTION, (Object)direction);
    }

    public Vector3f getShotDirection() {
        return (Vector3f)this.f_19804_.m_135370_(DIRECTION);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HIT_POS, Optional.empty());
        this.f_19804_.m_135372_(STATE, (Object)State.SHOT.ordinal());
        this.f_19804_.m_135372_(PREV_STATE, (Object)State.SHOT.ordinal());
        this.f_19804_.m_135372_(DELTA_MOVEMENT, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(REASON, (Object)Reason.EMPTY.ordinal());
        this.f_19804_.m_135372_(HOOK_TYPE, (Object)"");
        this.f_19804_.m_135372_(OWNER_ID, (Object)-1);
        this.f_19804_.m_135372_(RENDER_PARTICLES, (Object)true);
        this.f_19804_.m_135372_(DIRECTION, (Object)Vec3.f_82478_.m_252839_());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum State {
        SHOT,
        PULLING,
        RETRACTING,
        DONE;

    }

    public static enum Reason {
        EMPTY,
        SHOT,
        HIT,
        MISS,
        PLAYER,
        BREAK;

    }
}

