/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.entities.hook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.oe.rehooked.data.ChainRegistry;
import com.oe.rehooked.data.HookData;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.entities.hook.HookEntityModel;
import com.oe.rehooked.entities.layers.ReHookedModelLayers;
import com.oe.rehooked.utils.PositionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HookEntityRenderer
extends EntityRenderer<HookEntity> {
    protected EntityModel<HookEntity> model;
    protected EntityRendererProvider.Context pContext;
    protected float lastDelta;

    public HookEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new HookEntityModel(pContext.m_174023_(ReHookedModelLayers.HOOK_PROJECTILE_LAYER));
        this.pContext = pContext;
        this.lastDelta = 0.0f;
    }

    public boolean shouldRender(HookEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (pLivingEntity.m_213877_() || pLivingEntity.getHookType().isEmpty() || pLivingEntity.getState().equals((Object)HookEntity.State.DONE)) {
            return false;
        }
        if (pLivingEntity.tryGetOwnerFromCachedId() != null) {
            Player owner = pLivingEntity.tryGetOwnerFromCachedId();
            if (Minecraft.m_91087_().f_91074_ != null && owner.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                return true;
            }
            return pCamera.m_113029_(owner.m_20191_()) || super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ);
        }
        return false;
    }

    public void render(HookEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int maxBlockLight = LightTexture.m_109883_((int)pPackedLight);
        int skyLight = LightTexture.m_109894_((int)pPackedLight);
        Vec3 pos = pEntity.m_7371_(pPartialTicks);
        BlockPos blockPos = BlockPos.m_274446_((Position)pos);
        for (Direction direction : Direction.values()) {
            int blockLight = pEntity.m_9236_().m_45517_(LightLayer.BLOCK, blockPos.m_121945_(direction));
            if (blockLight <= maxBlockLight) continue;
            maxBlockLight = blockLight;
        }
        if (maxBlockLight == 0) {
            ++maxBlockLight;
        }
        int light = LightTexture.m_109885_((int)maxBlockLight, (int)skyLight);
        this.handleHook(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, light);
        if (pEntity.hasChain() && pEntity.tryGetOwnerFromCachedId() != null) {
            this.handleChain(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, light);
        }
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, light);
    }

    private void handleHook(HookEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        Vec3 direction = new Vec3(pEntity.getShotDirection());
        Vec3 lookAt = pEntity.m_146892_().m_82549_(direction);
        pEntity.m_7618_(EntityAnchorArgument.Anchor.EYES, lookAt);
        AABB box = pEntity.m_20191_();
        pPoseStack.m_85841_((float)box.m_82362_(), (float)box.m_82376_(), (float)box.m_82385_());
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(pEntity.m_146908_() + 270.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(pEntity.m_146909_() + 90.0f));
        pPoseStack.m_252880_(0.0f, -1.0f, 0.0f);
        this.model.m_7695_(pPoseStack, pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity))), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    private void handleChain(HookEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        int blockLight;
        int packedLight;
        pPoseStack.m_85836_();
        Player owner = pEntity.tryGetOwnerFromCachedId();
        Vec3 waistPos = PositionHelper.getWaistPosition((Entity)owner);
        Vec3 hookPos = pEntity.m_20182_();
        Vec3 playerToHook = waistPos.m_82505_(hookPos);
        Vec3 normal = playerToHook.m_82541_();
        Vec3 reverseNorm = normal.m_82548_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - (float)Mth.m_14136_((double)normal.f_82481_, (double)normal.f_82479_)));
        pPoseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.acos(normal.f_82480_) - (float)Math.PI));
        pPoseStack.m_85837_(-0.5, 0.0, -0.5);
        float distance = (float)playerToHook.m_82553_();
        BlockState chain = ChainRegistry.getChain(pEntity.getHookType()).m_49966_();
        Vec3 lightProbePosition = pEntity.m_7371_(pPartialTick).m_82546_(reverseNorm);
        int prevNotBlank = 1;
        for (int i = 0; i < (int)distance; ++i) {
            packedLight = HookEntityRenderer.getPackedLight(pEntity, lightProbePosition = lightProbePosition.m_82549_(reverseNorm));
            blockLight = LightTexture.m_109883_((int)packedLight);
            if (blockLight == 1) {
                packedLight = LightTexture.m_109885_((int)prevNotBlank, (int)LightTexture.m_109894_((int)packedLight));
            } else {
                prevNotBlank = blockLight;
            }
            this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, packedLight, OverlayTexture.f_118083_);
            pPoseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        float delta = distance - (float)((int)distance);
        if (this.lastDelta == 0.0f) {
            this.lastDelta = delta;
        }
        if (Math.abs(delta - this.lastDelta) < 0.3f) {
            delta = this.lastDelta;
        }
        pPoseStack.m_85841_(1.0f, delta, 1.0f);
        this.lastDelta = delta;
        lightProbePosition = lightProbePosition.m_82549_(reverseNorm.m_82490_((double)delta));
        packedLight = HookEntityRenderer.getPackedLight(pEntity, lightProbePosition);
        blockLight = LightTexture.m_109883_((int)packedLight);
        if (blockLight == 1) {
            packedLight = LightTexture.m_109885_((int)prevNotBlank, (int)LightTexture.m_109894_((int)packedLight));
        }
        this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, packedLight, OverlayTexture.f_118083_);
        pPoseStack.m_85849_();
    }

    private static int getPackedLight(HookEntity pEntity, Vec3 lightProbePosition) {
        BlockPos blockLightPos = BlockPos.m_274446_((Position)lightProbePosition);
        int blockLight = pEntity.m_9236_().m_45517_(LightLayer.BLOCK, blockLightPos);
        int skyLight = pEntity.m_9236_().m_45517_(LightLayer.SKY, blockLightPos);
        if (blockLight == 0) {
            ++blockLight;
        }
        if (skyLight == 0) {
            ++skyLight;
        }
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }

    public ResourceLocation getTextureLocation(HookEntity pEntity) {
        return pEntity.getHookData().map(HookData::texture).orElseGet(null);
    }
}

