/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.client;

import com.oe.rehooked.data.AdditionalHandlersRegistry;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.handlers.additional.def.IClientHandler;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.network.handlers.PacketHandler;
import com.oe.rehooked.network.packets.server.SHookCapabilityPacket;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class CPlayerHookHandler
implements IClientPlayerHookHandler {
    private final List<HookEntity> hooks = new ArrayList<HookEntity>();
    private Optional<Player> owner = Optional.empty();
    private Vec3 moveVector = null;
    private Vec3 momentum;
    private Vec3 lastPlayerPosition = null;
    private IClientHandler additional;

    @Override
    public void addHook(int id) {
        Player player;
        Entity entity;
        if (this.owner.isPresent() && (entity = (player = this.owner.get()).m_9236_().m_6815_(id)) instanceof HookEntity) {
            HookEntity hookEntity = (HookEntity)entity;
            this.hooks.add(hookEntity);
            hookEntity.m_5602_((Entity)player);
        }
    }

    @Override
    public void addHook(HookEntity hookEntity) {
        this.owner.ifPresentOrElse(owner -> {
            this.hooks.add(hookEntity);
            hookEntity.m_5602_((Entity)owner);
        }, () -> this.hooks.add(hookEntity));
    }

    @Override
    public void removeHook(int id) {
        this.hooks.removeIf(hookEntity -> hookEntity.m_19879_() == id);
    }

    @Override
    public void removeHook(HookEntity hookEntity) {
        PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.RETRACT_HOOK, hookEntity.m_19879_()));
        this.hooks.remove((Object)hookEntity);
    }

    @Override
    public void removeAllHooks() {
        if (this.hooks.isEmpty()) {
            return;
        }
        this.getOwner().ifPresent(owner -> PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.RETRACT_ALL_HOOKS)));
        this.hooks.clear();
    }

    @Override
    public void shootFromRotation(float xRot, float yRot) {
        PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.SHOOT, 0, xRot, yRot));
    }

    @Override
    public ICommonPlayerHookHandler setOwner(Player owner) {
        this.owner = Optional.of(owner);
        return this;
    }

    public Optional<Player> getOwner() {
        return this.owner;
    }

    @Override
    public Collection<HookEntity> getHooks() {
        return this.hooks;
    }

    @Override
    public void setDeltaVThisTick(Vec3 dV) {
        this.moveVector = dV;
    }

    @Override
    public Vec3 getMomentum() {
        return this.momentum;
    }

    @Override
    public void setMomentum(Vec3 momentum) {
        this.momentum = momentum;
    }

    @Override
    public void update() {
        this.moveVector = null;
        this.getOwner().ifPresent(owner -> {
            if (this.additional != null) {
                this.additional.Update();
            }
            this.getHookData().ifPresent(hookData -> {
                if (this.countPulling() == 0) {
                    return;
                }
                owner.m_6853_(false);
                Vec3 ownerWaistPos = PositionHelper.getWaistPosition((Entity)owner);
                float vPT = hookData.pullSpeed() / 20.0f;
                if (hookData.isCreative()) {
                    VectorHelper.Box box = this.getBox();
                    if (box.isInside(ownerWaistPos)) return;
                    this.moveVector = ownerWaistPos.m_82505_(box.closestPointInCube(ownerWaistPos));
                } else {
                    Vec3 pullCenter = this.getPullCenter();
                    double x = pullCenter.f_82479_ - ownerWaistPos.f_82479_;
                    double y = pullCenter.f_82480_ - ownerWaistPos.f_82480_;
                    double z = pullCenter.f_82481_ - ownerWaistPos.f_82481_;
                    this.moveVector = new Vec3(x, y, z);
                }
                this.moveVector = this.reduceCollisions(this.moveVector);
                if (this.moveVector.m_82553_() > (double)vPT) {
                    this.moveVector = this.moveVector.m_82541_().m_82490_((double)vPT);
                }
                if (hookData.isCreative() || !(this.moveVector.m_82553_() < 0.2)) return;
                this.moveVector = Vec3.f_82478_;
            });
            owner.m_6885_();
            this.updateMomentum();
        });
    }

    @Override
    public boolean shouldMoveThisTick() {
        return this.moveVector != null;
    }

    @Override
    public Vec3 getDeltaVThisTick() {
        return this.moveVector;
    }

    @Override
    public double getMaxHookDistance() {
        if (this.hooks.isEmpty() || this.getOwner().isEmpty()) {
            return 0.0;
        }
        Player owner = this.getOwner().get();
        Vec3 adjustedOwnerPosition = PositionHelper.getWaistPosition((Entity)owner);
        double maxDistance = 0.0;
        for (HookEntity hookEntity : this.hooks) {
            double distance = hookEntity.m_20182_().m_82554_(adjustedOwnerPosition);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        return maxDistance + 0.2;
    }

    @Override
    public Optional<Vec3> getLastPlayerPosition() {
        return Optional.ofNullable(this.lastPlayerPosition);
    }

    @Override
    public void storeLastPlayerPosition() {
        this.getOwner().ifPresent(owner -> {
            this.lastPlayerPosition = owner.m_20182_();
        });
    }

    @Override
    public void onUnequip() {
        IClientPlayerHookHandler.super.onUnequip();
        this.additional = null;
    }

    @Override
    public void onEquip() {
        IClientPlayerHookHandler.super.onEquip();
        this.additional = null;
        this.owner.flatMap(CurioUtils::GetHookType).flatMap(AdditionalHandlersRegistry::getHandler).ifPresent(cl -> {
            try {
                this.additional = (IClientHandler)cl.getDeclaredConstructor(IClientPlayerHookHandler.class).newInstance(this);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        });
    }
}

