/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.ForgeHooks;
import shetiphian.core.client.gui.AbstractWidgetList;

public class WidgetInfoBox
extends AbstractWidgetList<WIBEntry> {
    private List<FormattedCharSequence> lines;
    private final Font font;

    public WidgetInfoBox(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height, 10);
        this.font = mc.f_91062_;
        this.setFadeColors(0, 0);
        this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
    }

    public WidgetInfoBox addHeader(List<String> lines) {
        this.lines = this.resizeContent(lines);
        this.m_93473_(true, this.getHeaderHeight());
        return this;
    }

    private List<FormattedCharSequence> resizeContent(List<String> lines) {
        ArrayList<FormattedCharSequence> ret = new ArrayList<FormattedCharSequence>();
        for (String line : lines) {
            if (line == null) {
                ret.add(null);
                continue;
            }
            Component chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
            ret.addAll(ComponentRenderUtils.m_94005_((FormattedText)chat, (int)(this.m_5759_() - 8), (Font)this.font));
        }
        return ret;
    }

    private int getHeaderHeight() {
        int size = this.getBottom() - this.getTop() - 8;
        int height = 0;
        if ((height += this.lines.size() * 10) < size) {
            height = size;
        }
        return height;
    }

    protected void m_7415_(GuiGraphics graphics, int relativeX, int relativeY) {
        int top = relativeY;
        for (FormattedCharSequence line : this.lines) {
            if (line != null && top > this.f_93390_ - 10 && top < this.f_93391_) {
                RenderSystem.enableBlend();
                graphics.m_280648_(this.font, line, this.f_93393_ + 4, top, 0xFFFFFF);
                RenderSystem.disableBlend();
            }
            top += 10;
        }
    }

    @Override
    protected int m_5756_() {
        return this.f_93392_ - 6;
    }

    @Override
    public int m_5759_() {
        return this.f_93388_;
    }

    public void setInfo(WIBEntry info) {
        this.m_93516_();
        this.m_7085_(info);
    }

    public void clear() {
        this.m_93516_();
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, Tesselator tessellator, BufferBuilder bufferbuilder) {
    }

    @Override
    protected void renderHoleBackground(GuiGraphics graphics, Tesselator tessellator, BufferBuilder bufferbuilder, int y0, int y1) {
    }

    @Override
    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public static class WIBEntry
    extends AbstractWidgetList.AWLEntry<WIBEntry> {
        public void m_6311_(GuiGraphics graphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
        }
    }
}

