/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.Function;
import shetiphian.core.common.tileentity.TileEntityBase;

public class TileEntityExtendedRedstone
extends TileEntityBase {
    private final int MULTIPLIER;
    private final int MAXIMUM;
    private int redstone = 0;
    private boolean enabled = true;

    public TileEntityExtendedRedstone(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 5);
    }

    public TileEntityExtendedRedstone(BlockEntityType<?> type, BlockPos pos, BlockState state, int multiplier) {
        super(type, pos, state);
        this.MULTIPLIER = multiplier;
        this.MAXIMUM = 15 * this.MULTIPLIER;
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        nbtTag.m_128405_("redstone", this.redstone);
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        this.redstone = nbtTag.m_128451_("redstone");
    }

    public int getExPower() {
        return Mth.m_14045_((int)this.redstone, (int)0, (int)this.MAXIMUM);
    }

    public int getRSPower() {
        return Mth.m_14045_((int)(this.redstone / this.MULTIPLIER), (int)0, (int)15);
    }

    public void setExPower(int redstone) {
        this.redstone = Mth.m_14045_((int)redstone, (int)0, (int)this.MAXIMUM);
    }

    public void setRSPower(int redstone) {
        this.redstone = Mth.m_14045_((int)redstone, (int)0, (int)15) * this.MULTIPLIER;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean updatePower() {
        int powerIn;
        int newPower;
        int currentPower;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (currentPower = this.getExPower()) != (newPower = Mth.m_14045_((int)((powerIn = this.isEnabled() ? this.doPowerCalculation() : 0) - 1), (int)0, (int)this.MAXIMUM))) {
            this.setExPower(newPower);
            Function.syncTile(this);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            for (Direction direction : Direction.values()) {
                this.f_58857_.m_46672_(this.f_58858_.m_121945_(direction), this.m_58900_().m_60734_());
            }
            return true;
        }
        return false;
    }

    private int doPowerCalculation() {
        Direction direction;
        int power = 0;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (power = Math.max(power, this.getPowerAt(this.f_58858_.m_121945_(direction = directionArray[i]), direction))) < this.MAXIMUM; ++i) {
        }
        return Math.min(power, this.MAXIMUM);
    }

    private int getPowerAt(BlockPos pos, Direction direction) {
        if (this.f_58857_ != null) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (tile instanceof TileEntityExtendedRedstone) {
                return ((TileEntityExtendedRedstone)tile).getExPower();
            }
            return this.f_58857_.m_277185_(pos, direction) * this.MULTIPLIER;
        }
        return 0;
    }
}

