/*
 * Decompiled with CFR 0.152.
 */
package dev.joshument.steamdynamo.common.block.entity;

import cofh.lib.api.StorageGroup;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.util.managers.dynamo.StirlingFuelManager;
import cofh.thermal.lib.common.block.entity.DynamoBlockEntity;
import dev.joshument.steamdynamo.Config;
import dev.joshument.steamdynamo.Registry;
import dev.joshument.steamdynamo.common.inventory.DynamoSteamMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DynamoSteamBlockEntity
extends DynamoBlockEntity {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && StirlingFuelManager.instance().validFuel(item));
    protected FluidStorageCoFH waterTank = new FluidStorageCoFH(4000, fluid -> fluid.getFluid().m_6212_((Fluid)Fluids.f_76193_));
    protected int waterFuelBuffer = 0;

    public DynamoSteamBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.BlockEntities.DYNAMO_STEAM.get(), pos, state);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.tankInv.addTank(this.waterTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return StirlingFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return StirlingFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) > 0 && this.waterTank.getStored() > Config.waterConsumptionAmount;
    }

    protected void processStart() {
        if (this.fuel > 0) {
            return;
        }
        int fuelVal = Math.round((float)StirlingFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) * this.energyMod);
        this.processTick = Math.min(this.baseProcessTick, fuelVal);
        this.fuelMax = fuelVal;
        this.fuel += this.fuelMax;
        this.fuelSlot.consume(1);
    }

    protected int processTick() {
        if (this.waterFuelBuffer <= 0) {
            if (this.waterTank.getStored() >= Config.waterConsumptionAmount) {
                this.waterTank.modify(-Config.waterConsumptionAmount);
                this.waterFuelBuffer += (int)((float)Config.waterRFConsumptionAmount * this.energyMod);
            } else {
                this.isActive = false;
                return 0;
            }
        }
        this.waterFuelBuffer -= super.processTick();
        return 0;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DynamoSteamMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }
}

