/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.SysteamsRegistry;
import chiefarug.mods.systeams.TransferData;
import chiefarug.mods.systeams.block.BoilerBlock;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.lib.common.block.DynamoBlock;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConversionKitItem
extends Item {
    public static final BiMap<Block, BoilerBlock> dynamoBoilerMap = HashBiMap.create((int)7);

    public ConversionKitItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static void fillDynamoMap() {
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("stirling"), (Object)SysteamsRegistry.Boilers.STIRLING.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("compression"), (Object)SysteamsRegistry.Boilers.COMPRESSION.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("magmatic"), (Object)SysteamsRegistry.Boilers.MAGMATIC.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("numismatic"), (Object)SysteamsRegistry.Boilers.NUMISMATIC.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("lapidary"), (Object)SysteamsRegistry.Boilers.LAPIDARY.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("disenchantment"), (Object)SysteamsRegistry.Boilers.DISENCHANTMENT.block());
        dynamoBoilerMap.put((Object)ConversionKitItem.getDynamo("gourmand"), (Object)SysteamsRegistry.Boilers.GOURMAND.block());
    }

    public static BiMap<Block, BoilerBlock> getDynamoBoilerMap() {
        return dynamoBoilerMap;
    }

    private static DynamoBlock getDynamo(String id) {
        return (DynamoBlock)ThermalCore.BLOCKS.get("thermal:dynamo_" + id);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState oldState = level.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        Block dynamo = oldState.m_60734_();
        BoilerBlock boiler = (BoilerBlock)((Object)dynamoBoilerMap.get((Object)dynamo));
        if (boiler == null) {
            return super.m_6225_(context);
        }
        Player player = context.m_43723_();
        BlockState newState = (BlockState)((BlockState)boiler.m_49966_().m_61124_((Property)BlockStatePropertiesCoFH.FACING_ALL, (Comparable)((Direction)oldState.m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL)))).m_61124_((Property)DynamoBlock.WATERLOGGED, (Comparable)((Boolean)oldState.m_61143_((Property)DynamoBlock.WATERLOGGED)));
        ConversionKitItem.transformDynamoBoiler(pos, level, oldState, newState, player);
        if (player != null) {
            if (!player.m_150110_().f_35937_) {
                ItemStack converstionReturn = boiler.getOtherConversionItem();
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, converstionReturn);
                } else {
                    player.m_36356_(converstionReturn);
                }
            }
        } else {
            context.m_43722_().m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
    }

    public static void transformDynamoBoiler(BlockPos pos, Level level, BlockState oldState, BlockState newState, @Nullable Player player) {
        ArrayList<TransferData> transferData = new ArrayList<TransferData>();
        if (!level.m_5776_()) {
            BlockEntity oldBE = level.m_7702_(pos);
            ConversionKitItem.takeContents(oldBE, transferData);
        }
        level.m_7731_(pos, newState, 3);
        if (level.m_5776_()) {
            level.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)oldState));
        }
        if (!level.m_5776_()) {
            BlockEntity newBE = level.m_7702_(pos);
            ConversionKitItem.putContents(newBE, transferData);
        }
    }

    private static void takeContents(BlockEntity blockEntity, List<TransferData> transferData) {
        TransferData air;
        TransferData fluid;
        TransferData item = TransferData.item(blockEntity);
        if (item != null) {
            transferData.add(item);
        }
        if ((fluid = TransferData.fluid(blockEntity)) != null) {
            transferData.add(fluid);
        }
        if ((air = TransferData.air(blockEntity)) != null) {
            transferData.add(air);
        }
    }

    private static void putContents(BlockEntity blockEntity, List<TransferData> transferData) {
        for (TransferData transferDatum : transferData) {
            transferDatum.put(blockEntity);
        }
    }
}

