/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams;

import chiefarug.mods.systeams.Systeams;
import cofh.lib.common.fluid.SimpleTankInv;
import cofh.lib.common.inventory.SimpleItemInv;
import cofh.thermal.lib.common.block.entity.AugmentableBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

interface TransferData {
    public void take(BlockEntity var1);

    public void put(BlockEntity var1);

    public static TransferData from(TransferData data, BlockEntity be) {
        data.take(be);
        return data;
    }

    @Nullable
    public static TransferData item(BlockEntity be) {
        if (be.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || be instanceof AugmentableBlockEntity) {
            return TransferData.from(new ItemTransferData(), be);
        }
        return null;
    }

    @Nullable
    public static TransferData fluid(BlockEntity be) {
        if (be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent() || be instanceof AugmentableBlockEntity) {
            return TransferData.from(new FluidTransferData(), be);
        }
        return null;
    }

    @Nullable
    public static TransferData air(BlockEntity be) {
        if (be.getCapability(Systeams.AIR_HANDLER_CAPABILITY).isPresent()) {
            return TransferData.from(AirTransferData.from(), be);
        }
        return null;
    }

    public static class ItemTransferData
    implements TransferData {
        protected List<ItemStack> items = new ArrayList<ItemStack>();

        @Override
        public void take(BlockEntity be) {
            if (be instanceof AugmentableBlockEntity) {
                AugmentableBlockEntity abe = (AugmentableBlockEntity)be;
                this.takeFromThermal(abe);
            } else {
                this.takeFromOther(be);
            }
        }

        private void takeFromThermal(AugmentableBlockEntity abe) {
            SimpleItemInv oldInv = abe.getItemInv();
            for (int i = 0; i < oldInv.getSlots(); ++i) {
                this.items.add(oldInv.getSlot(i).extractItem(i, 64, false));
            }
        }

        private void takeFromOther(BlockEntity be) {
            LazyOptional oldInvLO = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
            oldInvLO.ifPresent(oldInvCap -> {
                for (int i = 0; i < oldInvCap.getSlots(); ++i) {
                    this.items.add(oldInvCap.extractItem(i, 64, false));
                }
            });
        }

        @Override
        public void put(BlockEntity be) {
            if (be instanceof AugmentableBlockEntity) {
                AugmentableBlockEntity abe = (AugmentableBlockEntity)be;
                this.putToThermal(abe);
            } else {
                this.putToOther(be);
            }
            this.items.forEach(item -> Block.m_49840_((Level)Objects.requireNonNull(be.m_58904_()), (BlockPos)be.m_58899_(), (ItemStack)item));
        }

        private void putToThermal(AugmentableBlockEntity abe) {
            SimpleItemInv newInv = abe.getItemInv();
            this.items.removeIf(item -> {
                for (int i = 0; i < newInv.getSlots(); ++i) {
                    if (item.m_41619_()) {
                        return true;
                    }
                    item = abe.getItemInv().insertItem(i, item, false);
                }
                return item.m_41619_();
            });
        }

        private void putToOther(BlockEntity be) {
            LazyOptional newInvLO = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
            newInvLO.ifPresent(newInvCap -> this.items.removeIf(item -> {
                for (int i = 0; i < newInvCap.getSlots(); ++i) {
                    if (item.m_41619_()) {
                        return true;
                    }
                    item = newInvCap.insertItem(i, item, false);
                }
                return item.m_41619_();
            }));
        }
    }

    public static class FluidTransferData
    implements TransferData {
        protected List<FluidStack> fluids = new ArrayList<FluidStack>();

        @Override
        public void take(BlockEntity be) {
            if (be instanceof AugmentableBlockEntity) {
                AugmentableBlockEntity abe = (AugmentableBlockEntity)be;
                this.takeFromThermal(abe);
            } else {
                this.takeFromOther(be);
            }
        }

        private void takeFromThermal(AugmentableBlockEntity abe) {
            SimpleTankInv oldTanks = abe.getTankInv();
            for (int i = 0; i < oldTanks.getTanks(); ++i) {
                this.fluids.add(oldTanks.getTank(i).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE));
            }
        }

        private void takeFromOther(BlockEntity be) {
            LazyOptional oldTankLO = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
            oldTankLO.ifPresent(oldTankCap -> {
                for (int i = 0; i < oldTankCap.getTanks(); ++i) {
                    this.fluids.add(oldTankCap.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE));
                }
            });
        }

        @Override
        public void put(BlockEntity be) {
            if (be instanceof AugmentableBlockEntity) {
                AugmentableBlockEntity abe = (AugmentableBlockEntity)be;
                this.putToThermal(abe);
            } else {
                this.putToOther(be);
            }
        }

        private void putToThermal(AugmentableBlockEntity abe) {
            SimpleTankInv newTanks = abe.getTankInv();
            this.fluids.removeIf(fluid -> {
                for (int i = 0; i < newTanks.getTanks(); ++i) {
                    if (fluid.isEmpty()) {
                        return true;
                    }
                    int remaining = newTanks.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    fluid.shrink(remaining);
                }
                return fluid.isEmpty();
            });
        }

        private void putToOther(BlockEntity be) {
            LazyOptional newTankLO = be.getCapability(ForgeCapabilities.FLUID_HANDLER);
            newTankLO.ifPresent(newTankCap -> this.fluids.removeIf(fluid -> {
                for (int i = 0; i < newTankCap.getTanks(); ++i) {
                    if (fluid.isEmpty()) {
                        return true;
                    }
                    int remaining = newTankCap.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    fluid.shrink(remaining);
                }
                return fluid.isEmpty();
            }));
        }
    }

    public static class AirTransferData
    implements TransferData {
        protected int amount;
        protected int volume;
        protected float pressure;
        protected boolean exists;

        private AirTransferData() {
        }

        public static AirTransferData from() {
            return new AirTransferData();
        }

        @Override
        public void take(BlockEntity be) {
            LazyOptional oldAirLO = be.getCapability(Systeams.AIR_HANDLER_CAPABILITY);
            oldAirLO.ifPresent(oldAirCap -> {
                this.amount = oldAirCap.getAir();
                this.pressure = oldAirCap.getPressure();
                this.volume = oldAirCap.getVolume();
                this.exists = true;
                oldAirCap.addAir(-this.amount);
            });
        }

        @Override
        public void put(BlockEntity be) {
            LazyOptional newAirLO = be.getCapability(Systeams.AIR_HANDLER_CAPABILITY);
            if (this.exists) {
                newAirLO.ifPresent(newAirCap -> {
                    if (newAirCap.getVolume() >= this.volume) {
                        newAirCap.addAir(this.amount);
                    } else {
                        newAirCap.setPressure(this.pressure);
                    }
                });
            }
        }
    }
}

