/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.player.videolan;

import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.player.videolan.BasePlayer;
import org.watermedia.api.render.RenderAPI;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.player.base.MediaPlayer;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferCleanupCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormat;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormatCallback;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.RenderCallback;

public class VideoPlayer
extends BasePlayer
implements RenderCallback,
BufferFormatCallback,
BufferCleanupCallback {
    private static final Marker IT = MarkerManager.getMarker((String)"VideoPlayer");
    private int width = 1;
    private int height = 1;
    private int size = this.width * this.height * 4;
    private boolean refresh = false;
    private boolean first = true;
    private final int texture;
    private final Semaphore semaphore = new Semaphore(1);
    private final Executor renderExecutor;
    private ByteBuffer[] buffers;

    public VideoPlayer(Executor renderExecutor) {
        this(null, renderExecutor);
    }

    public VideoPlayer(MediaPlayerFactory factory, Executor renderExecutor) {
        this.texture = RenderAPI.createTexture();
        this.renderExecutor = renderExecutor;
        this.init(factory, this, this, this);
        if (this.raw() == null) {
            RenderAPI.deleteTexture(this.texture);
        } else {
            this.raw().mediaPlayer().videoSurface().getVideoSurface().setSemaphore(this.semaphore);
        }
    }

    @Override
    public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
        this.refresh = true;
    }

    @Override
    public void allocatedBuffers(ByteBuffer[] buffers) {
        this.buffers = buffers;
    }

    @Override
    public void cleanupBuffers(ByteBuffer[] buffers) {
        this.semaphore.acquireUninterruptibly();
        this.buffers = null;
        this.semaphore.release();
    }

    @Override
    public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
        this.width = sourceWidth;
        this.height = sourceHeight;
        this.size = sourceWidth * sourceHeight * 4;
        this.first = true;
        return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
    }

    public int size() {
        return this.size;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int preRender() {
        RenderAPI.bindTexture(this.texture);
        if (this.refresh && this.buffers != null && this.buffers.length > 0) {
            this.semaphore.acquireUninterruptibly();
            RenderAPI.uploadBuffer(this.buffers[0], this.texture, 6408, this.width, this.height, this.first);
            this.first = false;
            this.semaphore.release();
        }
        RenderAPI.bindTexture(0);
        return this.texture;
    }

    public int texture() {
        return this.texture;
    }

    public Dimension dimension() {
        if (this.raw() == null) {
            return null;
        }
        return this.raw().mediaPlayer().video().videoDimension();
    }

    @Override
    public void release() {
        this.renderExecutor.execute(() -> RenderAPI.deleteTexture(this.texture));
        super.release();
    }
}

