/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.model.videos.formats;

import com.alibaba.fastjson.JSONObject;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.Format;
import org.watermedia.shaded.kiulian.downloader.model.videos.quality.AudioQuality;

public class AudioFormat
extends Format {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;

    public AudioFormat(JSONObject json, boolean isAdaptive, String clientVersion) {
        super(json, isAdaptive, clientVersion);
        this.audioSampleRate = json.getInteger("audioSampleRate");
        this.averageBitrate = json.getInteger("averageBitrate");
        AudioQuality audioQuality = null;
        if (json.containsKey("audioQuality")) {
            String[] split = json.getString("audioQuality").split("_");
            String quality = split[split.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(quality);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio";
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

