/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.factory;

import java.util.ArrayList;
import java.util.List;
import org.watermedia.videolan4j.binding.internal.libvlc_module_description_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.factory.BaseApi;
import org.watermedia.videolan4j.factory.MediaPlayerFactory;
import org.watermedia.videolan4j.factory.ModuleDescription;
import org.watermedia.videolan4j.log.NativeLog;
import org.watermedia.videolan4j.media.TrackType;

public final class ApplicationApi
extends BaseApi {
    ApplicationApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public String version() {
        return LibVlc.libvlc_get_version();
    }

    public String compiler() {
        return LibVlc.libvlc_get_compiler();
    }

    public String changeset() {
        return LibVlc.libvlc_get_changeset();
    }

    public void setUserAgent(String userAgent) {
        this.setUserAgent(userAgent, null);
    }

    public void setUserAgent(String userAgent, String httpUserAgent) {
        LibVlc.libvlc_set_user_agent(this.libvlcInstance, userAgent, httpUserAgent);
    }

    public void setApplicationId(String id, String version, String icon) {
        LibVlc.libvlc_set_app_id(this.libvlcInstance, id, version, icon);
    }

    public NativeLog newLog() {
        return new NativeLog(this.libvlcInstance);
    }

    public long clock() {
        return LibVlc.libvlc_clock();
    }

    public String codecDescription(TrackType type, int codec) {
        return LibVlc.libvlc_media_get_codec_description(type.intValue(), codec);
    }

    public List<ModuleDescription> audioFilters() {
        libvlc_module_description_t moduleDescriptions = LibVlc.libvlc_audio_filter_list_get(this.libvlcInstance);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        LibVlc.libvlc_module_description_list_release(moduleDescriptions.getPointer());
        return result;
    }

    public List<ModuleDescription> videoFilters() {
        libvlc_module_description_t moduleDescriptions = LibVlc.libvlc_video_filter_list_get(this.libvlcInstance);
        List<ModuleDescription> result = this.getModuleDescriptions(moduleDescriptions);
        LibVlc.libvlc_module_description_list_release(moduleDescriptions.getPointer());
        return result;
    }

    private List<ModuleDescription> getModuleDescriptions(libvlc_module_description_t moduleDescriptions) {
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        libvlc_module_description_t moduleDescription = moduleDescriptions;
        while (moduleDescription != null) {
            result.add(new ModuleDescription(moduleDescription.psz_name, moduleDescription.psz_shortname, moduleDescription.psz_longname, moduleDescription.psz_help));
            moduleDescription = moduleDescription.p_next;
        }
        return result;
    }
}

